/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.util;

import com.github.database.rider.core.spi.DriverNameService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ServiceLoader;

public class DriverUtils {
    public static boolean isMsSql(String driverName) {
        return DriverUtils.hasKeywordInDriverName(driverName, "sql server");
    }

    public static boolean isHsql(String driverName) {
        return DriverUtils.hasKeywordInDriverName(driverName, "hsql");
    }

    public static boolean isH2(String driverName) {
        return DriverUtils.hasKeywordInDriverName(driverName, "h2");
    }

    public static boolean isMysql(String driverName) {
        return DriverUtils.hasKeywordInDriverName(driverName, "mysql");
    }

    public static boolean isPostgre(String driverName) {
        return DriverUtils.hasKeywordInDriverName(driverName, "postgre");
    }

    public static boolean isOracle(String driverName) {
        return DriverUtils.hasKeywordInDriverName(driverName, "oracle");
    }

    public static boolean isDB2(String driverName) {
        return DriverUtils.hasKeywordInDriverName(driverName, "db2");
    }

    public static String getDriverName(Connection connection) {
        try {
            ServiceLoader<DriverNameService> driverNameService = ServiceLoader.load(DriverNameService.class);
            if (driverNameService.iterator().hasNext()) {
                return driverNameService.iterator().next().getDriverName(connection);
            }
            return connection.getMetaData().getDriverName().toLowerCase();
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not get driver information from provided connection.", e);
        }
    }

    private static boolean hasKeywordInDriverName(String driverName, String keyword) {
        return driverName != null && driverName.contains(keyword);
    }
}

