/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.util;

import java.util.HashMap;
import java.util.Map;

public class PropertyResolutionUtil {
    private static final String PROP_FILTER = "^javax.persistence.(.*)|^eclipselink.(.*)|^hibernate.(.*)|^openjpa.(.)*";

    public Map<String, String> getSystemJavaxPersistenceOverrides() {
        if (this.propertyOverridesExist()) {
            return this.mergeFilteredMaps(System.getenv(), System.getProperties());
        }
        return null;
    }

    public Map<String, String> persistencePropertiesOverrides(Map<String, String> overridingProperties) {
        if (overridingProperties == null) {
            throw new IllegalArgumentException("the property 'overridingProperties' is not allowed to be null.");
        }
        HashMap<String, String> overridingProperttiesCopy = new HashMap<String, String>(overridingProperties);
        return this.mergeFilteredMaps(this.getSystemJavaxPersistenceOverrides(), overridingProperttiesCopy);
    }

    boolean propertyOverridesExist() {
        return System.getProperties().containsKey("javax.persistence.jdbc.url") || System.getProperties().containsKey("javax.persistence.jdbc.user") || System.getProperties().containsKey("javax.persistence.jdbc.password") || System.getProperties().containsKey("javax.persistence.jdbc.driver") || System.getenv().containsKey("javax.persistence.jdbc.url") || System.getenv().containsKey("javax.persistence.jdbc.user") || System.getenv().containsKey("javax.persistence.jdbc.password") || System.getenv().containsKey("javax.persistence.jdbc.driver");
    }

    Map<String, String> mergeFilteredMaps(Map<String, String> ... enlistedMaps) {
        HashMap<String, String> targetMap = new HashMap<String, String>();
        for (Map<String, String> map : enlistedMaps) {
            if (map == null) continue;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!entry.getKey().matches(PROP_FILTER)) continue;
                targetMap.put(entry.getKey(), entry.getValue());
            }
        }
        return targetMap.size() > 0 ? targetMap : null;
    }
}

