/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.api.dataset;

import com.github.database.rider.core.script.ScriptEngineManagerWrapper;
import java.util.logging.Logger;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;

public class ScriptableTable
implements ITable {
    private static final Logger log = Logger.getLogger(ScriptableTable.class.getName());
    private final ScriptEngineManagerWrapper manager;
    private final ITable delegate;

    public ScriptableTable(ITable delegate) {
        this.delegate = delegate;
        this.manager = ScriptEngineManagerWrapper.getInstance();
    }

    public ITableMetaData getTableMetaData() {
        return this.delegate.getTableMetaData();
    }

    public int getRowCount() {
        return this.delegate.getRowCount();
    }

    public Object getValue(int row, String column) throws DataSetException {
        Object value = this.delegate.getValue(row, column);
        if (this.manager.rowValueContainsScriptEngine(value) && !this.manager.hasScriptExpression(value)) {
            try {
                return this.manager.getScriptResult(value.toString());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not evaluate script expression: '%s' for table '%s', column '%s'.", value, this.getTableMetaData().getTableName(), column), e);
            }
        }
        return value;
    }
}

