/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.dataset.builder;

import com.github.database.rider.core.configuration.DBUnitConfig;
import com.github.database.rider.core.dataset.builder.BuilderUtil;
import com.github.database.rider.core.util.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;

public class BasicRowBuilder {
    private final String tableName;
    protected final DBUnitConfig config;
    protected final Map<String, Object> columnNameToValue = new LinkedHashMap<String, Object>();
    private boolean added;

    public BasicRowBuilder(String tableName, DBUnitConfig config) {
        this.config = config;
        this.tableName = BuilderUtil.convertCase(tableName, config);
    }

    public BasicRowBuilder column(String columnName, Object value) {
        this.columnNameToValue.put(BuilderUtil.convertCase(columnName, this.config), value);
        return this;
    }

    protected Object[] values(Column[] columns) {
        Object[] values = new Object[columns.length];
        int index = 0;
        for (Column column : columns) {
            if (column == null || "".equals(column.getColumnName())) continue;
            values[index++] = this.getValue(column);
        }
        return values;
    }

    protected ITableMetaData toMetaData() {
        Column[] columns = new Column[this.numberOfColumns()];
        int index = 0;
        for (String columnName : this.columnNameToValue.keySet()) {
            columns[index++] = this.createColumn(columnName);
        }
        return this.createMetaData(columns);
    }

    protected int numberOfColumns() {
        return this.columnNameToValue.size();
    }

    protected Map<String, Object> getColumnsValues() {
        return this.columnNameToValue;
    }

    protected ITableMetaData createMetaData(Column[] columns) {
        return new DefaultTableMetaData(this.tableName, columns);
    }

    protected Column createColumn(String columnName) {
        DataType columnType = DataType.UNKNOWN;
        return new Column(columnName, columnType);
    }

    protected String getTableName() {
        return this.tableName;
    }

    protected void put(String columnName, Object value) {
        this.columnNameToValue.put(BuilderUtil.convertCase(columnName, this.config), value);
    }

    protected Object getValue(Column column) {
        return this.getValue(column.getColumnName());
    }

    protected Object getValue(String columnName) {
        return this.columnNameToValue.get(columnName);
    }

    protected boolean hasColumns() {
        return !this.columnNameToValue.isEmpty();
    }

    protected boolean isAdded() {
        return this.added;
    }

    protected void setAdded(boolean added) {
        this.added = added;
    }

    protected Object formatDateValue(Object value) {
        if (value instanceof Date) {
            return DateUtils.format((Date)value);
        }
        if (value instanceof Calendar) {
            return DateUtils.format((Calendar)value);
        }
        return value;
    }
}

