/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.filter;

import java.util.List;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.filter.IColumnFilter;

public class RiderPrimaryKeyFilter
implements IColumnFilter {
    private List<String> disablePrimaryKeyForTables;

    public RiderPrimaryKeyFilter(List<String> disablePrimaryKeyForTables) {
        this.disablePrimaryKeyForTables = disablePrimaryKeyForTables;
    }

    public boolean accept(String tableName, Column column) {
        if (tableName == null || this.disablePrimaryKeyForTables == null || this.disablePrimaryKeyForTables.isEmpty()) {
            return false;
        }
        for (String disablePrimaryKeyForTable : this.disablePrimaryKeyForTables) {
            if (!tableName.equalsIgnoreCase(disablePrimaryKeyForTable)) continue;
            return true;
        }
        return false;
    }
}

