/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.leak;

import com.github.database.rider.core.leak.AbstractLeakHunter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class MySqlLeakHunter
extends AbstractLeakHunter {
    private final String sql = "SELECT COUNT(*) FROM v$session WHERE status = 'INACTIVE'";

    public MySqlLeakHunter(Connection connection, String methodName, boolean cacheConnection) {
        super(connection, methodName, cacheConnection);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int openConnections() {
        try (Statement statement = this.connection.createStatement();){
            int n;
            block15: {
                ResultSet resultSet = statement.executeQuery("SHOW PROCESSLIST");
                try {
                    int count = 0;
                    while (resultSet.next()) {
                        String state = resultSet.getString("command");
                        if (!"sleep".equalsIgnoreCase(state)) continue;
                        ++count;
                    }
                    n = count;
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected String leakCountSql() {
        return "SELECT COUNT(*) FROM v$session WHERE status = 'INACTIVE'";
    }
}

