/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.replacers;

import com.github.database.rider.core.api.replacer.DayReplacerType;
import com.github.database.rider.core.api.replacer.HourReplacerType;
import com.github.database.rider.core.api.replacer.MinuteReplacerType;
import com.github.database.rider.core.api.replacer.ReplacerType;
import com.github.database.rider.core.api.replacer.SecondReplacerType;
import com.github.database.rider.core.replacers.Replacer;
import com.github.database.rider.core.util.DateUtils;
import java.util.Calendar;
import java.util.Date;
import org.dbunit.dataset.ReplacementDataSet;

public class DateTimeReplacer
implements Replacer {
    public static final String PLACEHOLDER_FORMAT = "[%s,%s]";

    @Override
    public void addReplacements(ReplacementDataSet dataSet) {
        Date currentDate = new Date();
        this.replaceDays(currentDate, dataSet);
        this.replaceHours(currentDate, dataSet);
        this.replaceMinutes(currentDate, dataSet);
        this.replaceSeconds(currentDate, dataSet);
    }

    private void replaceDays(Date currentDate, ReplacementDataSet replacementDataSet) {
        for (DayReplacerType type : DayReplacerType.values()) {
            Date calculatedDate = this.addDays(currentDate, type.getDays());
            replacementDataSet.addReplacementSubstring(this.getPlaceholderPattern(type), DateUtils.formatDateTime(calculatedDate));
        }
    }

    private void replaceHours(Date currentDate, ReplacementDataSet replacementDataSet) {
        for (HourReplacerType type : HourReplacerType.values()) {
            Date calculatedDate = this.addHours(currentDate, type.getHours());
            replacementDataSet.addReplacementSubstring(this.getPlaceholderPattern(type), DateUtils.formatDateTime(calculatedDate));
        }
    }

    private void replaceMinutes(Date currentDate, ReplacementDataSet replacementDataSet) {
        for (MinuteReplacerType type : MinuteReplacerType.values()) {
            Date calculatedDate = this.addMinutes(currentDate, type.getMinutes());
            replacementDataSet.addReplacementSubstring(this.getPlaceholderPattern(type), DateUtils.formatDateTime(calculatedDate));
        }
    }

    private void replaceSeconds(Date currentDate, ReplacementDataSet replacementDataSet) {
        for (SecondReplacerType type : SecondReplacerType.values()) {
            Date calculatedDate = this.addSeconds(currentDate, type.getSeconds());
            replacementDataSet.addReplacementSubstring(this.getPlaceholderPattern(type), DateUtils.formatDateTime(calculatedDate));
        }
    }

    private String getPlaceholderPattern(ReplacerType replacerType) {
        return String.format(PLACEHOLDER_FORMAT, replacerType.getPerfix(), replacerType.getName());
    }

    private Date addMinutes(Date currentDate, int minutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(12, minutes);
        return calendar.getTime();
    }

    private Date addDays(Date currentDate, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(5, days);
        return calendar.getTime();
    }

    private Date addHours(Date currentDate, int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(11, hours);
        return calendar.getTime();
    }

    private Date addSeconds(Date currentDate, int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(13, seconds);
        return calendar.getTime();
    }
}

