/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.replacers;

import com.github.database.rider.core.replacers.Replacer;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ReplacementDataSet;

public class IncludeReplacer
implements Replacer {
    private static final String INCLUDE_PREFIX = "[INCLUDE]";

    @Override
    public void addReplacements(ReplacementDataSet dataSet) {
        try {
            String[] tableNames;
            for (String tableName : tableNames = dataSet.getTableNames()) {
                this.addReplacementsForTable(tableName, dataSet);
            }
        }
        catch (DataSetException e) {
            throw new RuntimeException("Unable to perform classpath file replacements", e);
        }
    }

    private void addReplacementsForTable(String tableName, ReplacementDataSet dataSet) throws DataSetException {
        ITable table = dataSet.getTable(tableName);
        Column[] columns = table.getTableMetaData().getColumns();
        for (int i = 0; i < table.getRowCount(); ++i) {
            for (Column column : columns) {
                String columnValue = (String)table.getValue(i, column.getColumnName());
                if (!this.hasIncludePrefix(columnValue)) continue;
                String filePath = this.removeIncludePrefix(columnValue);
                String fileContent = this.readFile(filePath);
                dataSet.addReplacementSubstring(columnValue, fileContent);
            }
        }
    }

    private boolean hasIncludePrefix(String value) {
        return value != null && value.startsWith(INCLUDE_PREFIX);
    }

    private String removeIncludePrefix(String columnValue) {
        return columnValue.substring(INCLUDE_PREFIX.length());
    }

    private String readFile(String filePath) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(filePath);
        if (inputStream == null) {
            String fileNotFoundError = String.format("Unable to read file [%s] from the classpath", filePath);
            throw new RuntimeException(fileNotFoundError);
        }
        try (Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name());){
            String string = scanner.useDelimiter("\\A").next();
            return string;
        }
    }
}

