/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.script;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptEngineManagerWrapper {
    private static final ScriptEngineManagerWrapper INSTANCE = new ScriptEngineManagerWrapper();
    private static final Pattern SCRIPT_EXPRESSION_PATTERN = Pattern.compile("\\b((js|groovy):\\((.*value.*)\\))");
    private final ScriptEngineManager manager;
    private final Map<String, ScriptEngine> engines = new HashMap<String, ScriptEngine>();

    private ScriptEngineManagerWrapper() {
        this.manager = new ScriptEngineManager();
    }

    public static ScriptEngineManagerWrapper getInstance() {
        return INSTANCE;
    }

    public boolean rowValueContainsScriptEngine(Object value) {
        if (value == null || value.toString().length() == 0) {
            return false;
        }
        String rowValueLowerCase = value.toString().toLowerCase();
        return rowValueLowerCase.startsWith("js:") || rowValueLowerCase.startsWith("groovy:");
    }

    public Object getScriptResult(String script) throws ScriptException {
        ScriptEngine engine = this.getScriptEngine(script.trim());
        String scriptToExecute = this.getScriptToExecute(script);
        return engine.eval(scriptToExecute);
    }

    public boolean getScriptAssert(String script, Object actualValue) throws ScriptException {
        ScriptEngine engine = this.getScriptEngine(script.trim());
        String scriptToExecute = this.getScriptToExecute(script);
        engine.put("value", actualValue);
        Object result = engine.eval(scriptToExecute);
        return Boolean.parseBoolean(result.toString());
    }

    private ScriptEngine getScriptEngine(String value) {
        String engineName = value.substring(0, value.indexOf(58));
        if (this.engines.containsKey(engineName)) {
            return this.engines.get(engineName);
        }
        ScriptEngine engine = this.manager.getEngineByName(engineName);
        if (engine == null) {
            throw new RuntimeException(String.format("Could not find script engine by name '%s'", engineName));
        }
        this.engines.put(engineName, engine);
        return engine;
    }

    private String getScriptToExecute(String script) {
        return script.substring(script.indexOf(58) + 1);
    }

    public boolean hasScriptExpression(Object script) {
        if (script == null) {
            return false;
        }
        return SCRIPT_EXPRESSION_PATTERN.matcher(script.toString()).matches();
    }
}

