/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.spring;

import com.github.database.rider.core.AbstractRiderTestContext;
import com.github.database.rider.core.api.connection.ConnectionHolder;
import com.github.database.rider.core.api.dataset.DataSetExecutor;
import com.github.database.rider.core.dataset.DataSetExecutorImpl;
import com.github.database.rider.spring.api.DBRider;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.test.context.TestContext;

class SpringRiderTestContext
extends AbstractRiderTestContext {
    private static final String EMPTY_STRING = "";
    private final TestContext testContext;

    static SpringRiderTestContext create(TestContext testContext) {
        return new SpringRiderTestContext(SpringRiderTestContext.createDataSetExecutor(testContext), testContext);
    }

    private static DataSetExecutor createDataSetExecutor(TestContext testContext) {
        String beanName = SpringRiderTestContext.getConfiguredDataSourceBeanName(testContext);
        DataSource dataSourceBean = SpringRiderTestContext.getDataSource(testContext, beanName);
        final DataSource dataSource = SpringRiderTestContext.wrapInTransactionAwareProxy(dataSourceBean);
        String instanceId = beanName.isEmpty() ? "default" : beanName;
        DataSetExecutorImpl dataSetExecutor = DataSetExecutorImpl.instance((String)instanceId, (ConnectionHolder)new ConnectionHolder(){

            public Connection getConnection() throws SQLException {
                return dataSource.getConnection();
            }
        });
        dataSetExecutor.clearRiderDataSource();
        return dataSetExecutor;
    }

    private static DataSource getDataSource(TestContext testContext, String beanName) {
        ApplicationContext context = testContext.getApplicationContext();
        return beanName.isEmpty() ? (DataSource)context.getBean(DataSource.class) : (DataSource)context.getBean(beanName, DataSource.class);
    }

    private static String getConfiguredDataSourceBeanName(TestContext testContext) {
        DBRider dbRiderAnnotation = testContext.getTestMethod().getAnnotation(DBRider.class);
        if (dbRiderAnnotation == null) {
            dbRiderAnnotation = testContext.getTestClass().getAnnotation(DBRider.class);
        }
        return dbRiderAnnotation != null ? dbRiderAnnotation.dataSourceBeanName() : EMPTY_STRING;
    }

    private static DataSource wrapInTransactionAwareProxy(DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            return dataSource;
        }
        return new TransactionAwareDataSourceProxy(dataSource);
    }

    private SpringRiderTestContext(DataSetExecutor executor, TestContext testContext) {
        super(executor);
        this.testContext = testContext;
    }

    public String getMethodName() {
        return this.testContext.getTestMethod().getName();
    }

    public <T extends Annotation> T getMethodAnnotation(Class<T> clazz) {
        return (T)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.testContext.getTestMethod(), clazz);
    }

    public <T extends Annotation> T getClassAnnotation(Class<T> clazz) {
        return (T)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.testContext.getTestClass(), clazz);
    }

    public void commit() throws SQLException {
    }

    public void beginTransaction() throws SQLException {
    }

    public void rollback() throws SQLException {
    }

    public void clearEntityManager() {
    }
}

