/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes;

import com.digitaldan.jomnilinkII.Message;

public final class CommandMessage
implements Message {
    private final int command;
    private final int parameter1;
    private final int parameter2;
    public static final int CMD_UNIT_OFF = 0;
    public static final int CMD_UNIT_ON = 1;
    public static final int CMD_UNIT_AREA_ALL_OFF = 2;
    public static final int CMD_UNIT_AREA_ALL_ON = 3;
    public static final int CMD_UNIT_PERCENT = 9;
    public static final int CMD_UNIT_LO9_LEVEL_HIGH7 = 101;
    public static final int CMD_UNIT_DECREMENT_COUNTER = 10;
    public static final int CMD_UNIT_INCREMENT_COUNTER = 11;
    public static final int CMD_UNIT_SET_COUNTER = 12;
    public static final int CMD_UNIT_LO9_RAMP_HIGH7 = 13;
    public static final int CMD_UNIT_LIGHTOLIER = 14;
    public static final int CMD_UNIT_UPB_REQ_STATUS = 15;
    public static final int CMD_UNIT_UPB_DIM_STEP_1 = 17;
    public static final int CMD_UNIT_UPB_DIM_STEP_2 = 18;
    public static final int CMD_UNIT_UPB_DIM_STEP_3 = 19;
    public static final int CMD_UNIT_UPB_DIM_STEP_4 = 20;
    public static final int CMD_UNIT_UPB_DIM_STEP_5 = 21;
    public static final int CMD_UNIT_UPB_DIM_STEP_6 = 22;
    public static final int CMD_UNIT_UPB_DIM_STEP_7 = 23;
    public static final int CMD_UNIT_UPB_DIM_STEP_8 = 24;
    public static final int CMD_UNIT_UPB_DIM_STEP_9 = 25;
    public static final int CMD_UNIT_UPB_BRIGHTEN_STEP_1 = 33;
    public static final int CMD_UNIT_UPB_BRIGHTEN_STEP_2 = 34;
    public static final int CMD_UNIT_UPB_BRIGHTEN_STEP_3 = 35;
    public static final int CMD_UNIT_UPB_BRIGHTEN_STEP_4 = 36;
    public static final int CMD_UNIT_UPB_BRIGHTEN_STEP_5 = 37;
    public static final int CMD_UNIT_UPB_BRIGHTEN_STEP_6 = 38;
    public static final int CMD_UNIT_UPB_BRIGHTEN_STEP_7 = 39;
    public static final int CMD_UNIT_UPB_BRIGHTEN_STEP_8 = 40;
    public static final int CMD_UNIT_UPB_BRIGHTEN_STEP_9 = 41;
    public static final int CMD_UNIT_UPB_LO9_BLINK_HIGH7 = 26;
    public static final int CMD_UNIT_UPB_STOP_BLINK = 27;
    public static final int CMD_UNIT_UPB_LINK_OFF = 28;
    public static final int CMD_UNIT_UPB_LINK_ON = 29;
    public static final int CMD_UNIT_UPB_LINK_SET = 30;
    public static final int CMD_UNIT_CENTRALITE_SCENE_OFF = 42;
    public static final int CMD_UNIT_CENTRALITE_SCENE_ON = 43;
    public static final int CMD_UNIT_UPB_LED_OFF = 44;
    public static final int CMD_UNIT_UPB_LED_ON = 45;
    public static final int CMD_UNIT_RADIORA_PHANTOM_BUTTON_OFF = 46;
    public static final int CMD_UNIT_RADIORA_PHANTOM_BUTTON_ON = 46;
    public static final int CMD_UNIT_LEVITON_SCENE_OFF = 60;
    public static final int CMD_UNIT_LEVITON_SCENE_ON = 61;
    public static final int CMD_UNIT_LEVITON_SCENE_SET = 62;
    public static final int CMD_SECURITY_OMNI_DISARM = 48;
    public static final int CMD_SECURITY_OMNI_DAY_MODE = 49;
    public static final int CMD_SECURITY_OMNI_NIGHT_MODE = 50;
    public static final int CMD_SECURITY_OMNI_AWAY_MODE = 51;
    public static final int CMD_SECURITY_OMNI_VACATION_MODE = 52;
    public static final int CMD_SECURITY_OMNI_DAY_INSTANT_MODE = 53;
    public static final int CMD_SECURITY_OMNI_NIGHT_DELAYED_MODE = 54;
    public static final int CMD_SECURITY_BYPASS_ZONE = 4;
    public static final int CMD_SECURITY_RESTORE_ZONE = 5;
    public static final int CMD_SECURITY_RESTORE_ALL_ZONES = 6;
    public static final int CMD_SECURITY_LUMINA_HOME_MODE = 49;
    public static final int CMD_SECURITY_LUMINA_SLEEP_MODE = 50;
    public static final int CMD_SECURITY_LUMINA_AWAY_MODE = 51;
    public static final int CMD_SECURITY_LUMINA_VACATION_MODE = 52;
    public static final int CMD_SECURITY_LUMINA_PARTY_MODE = 53;
    public static final int CMD_SECURITY_LUMINA_SPECIAL_MODE = 54;
    public static final int CMD_BUTTON = 7;
    public static final int CMD_ENERGY_COST_SET = 8;
    public static final int CMD_ENERGY_SAVER_OFF = 64;
    public static final int CMD_ENERGY_SAVER_ON = 65;
    public static final int CMD_THERMO_SET_HEAT_POINT = 66;
    public static final int CMD_THERMO_SET_COOL_POINT = 67;
    public static final int CMD_THERMO_SET_SYSTEM_MODE = 68;
    public static final int CMD_THERMO_SET_FAN_MODE = 69;
    public static final int CMD_THERMO_SET_HOLD_MODE = 70;
    public static final int CMD_THERMO_RAISE_LOWER_HEAT = 71;
    public static final int CMD_THERMO_RAISE_LOWER_COOL = 72;
    public static final int CMD_THERMO_SET_HUMDIFY_POINT = 73;
    public static final int CMD_THERMO_SET_DEHUMIDIFY_POINT = 74;
    public static final int CMD_MESSAGE_SHOW_MESSAGE_WITH_BEEP_AND_LED = 80;
    public static final int CMD_MESSAGE_SHOW_MESSAGE_WITH_BEEP_OR_LED = 86;
    public static final int CMD_MESSAGE_LOG_MESSAGE = 81;
    public static final int CMD_MESSAGE_CLEAR_MESSAGE = 82;
    public static final int CMD_MESSAGE_SAY_MESSAGE = 83;
    public static final int CMD_MESSAGE_PHONE_AND_SAY_MESSAGE = 84;
    public static final int CMD_MESSAGE_SEND_MESSAGE_TO_SERIAL_PORT = 85;
    public static final int CMD_CONSOLE_ENABLE_DISABLE_BEEPER = 102;
    public static final int CMD_CONSOLE_BEEP = 103;
    public static final int CMD_UNLOCK_DOOR = 105;
    public static final int CMD_LOCK_DOOR = 106;
    public static final int CMD_AUDIO_ZONE_SET_ON_AND_MUTE = 112;
    public static final int CMD_AUDIO_ZONE_SET_VOLUME = 113;
    public static final int CMD_AUDIO_ZONE_SET_SOURCE = 114;
    public static final int CMD_AUDIO_ZONE_SELECT_KEY = 115;

    @Override
    public int getMessageType() {
        return 20;
    }

    public static CommandMessageBuilder builder() {
        return new CommandMessageBuilder();
    }

    public int getCommand() {
        return this.command;
    }

    public int getParameter1() {
        return this.parameter1;
    }

    public int getParameter2() {
        return this.parameter2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandMessage)) {
            return false;
        }
        CommandMessage other = (CommandMessage)o;
        if (this.getCommand() != other.getCommand()) {
            return false;
        }
        if (this.getParameter1() != other.getParameter1()) {
            return false;
        }
        return this.getParameter2() == other.getParameter2();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCommand();
        result = result * 59 + this.getParameter1();
        result = result * 59 + this.getParameter2();
        return result;
    }

    public String toString() {
        return "CommandMessage(command=" + this.getCommand() + ", parameter1=" + this.getParameter1() + ", parameter2=" + this.getParameter2() + ")";
    }

    private CommandMessage(int command, int parameter1, int parameter2) {
        this.command = command;
        this.parameter1 = parameter1;
        this.parameter2 = parameter2;
    }

    public static class CommandMessageBuilder {
        private int command;
        private int parameter1;
        private int parameter2;

        CommandMessageBuilder() {
        }

        public CommandMessageBuilder command(int command) {
            this.command = command;
            return this;
        }

        public CommandMessageBuilder parameter1(int parameter1) {
            this.parameter1 = parameter1;
            return this;
        }

        public CommandMessageBuilder parameter2(int parameter2) {
            this.parameter2 = parameter2;
            return this;
        }

        public CommandMessage build() {
            return new CommandMessage(this.command, this.parameter1, this.parameter2);
        }

        public String toString() {
            return "CommandMessage.CommandMessageBuilder(command=" + this.command + ", parameter1=" + this.parameter1 + ", parameter2=" + this.parameter2 + ")";
        }
    }
}

