/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes;

import com.digitaldan.jomnilinkII.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ConnectedSecurityStatus
implements Message {
    private final List<Partition> partitions;

    @Override
    public int getMessageType() {
        return 25;
    }

    ConnectedSecurityStatus(List<Partition> partitions) {
        this.partitions = partitions;
    }

    public static ConnectedSecurityStatusBuilder builder() {
        return new ConnectedSecurityStatusBuilder();
    }

    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectedSecurityStatus)) {
            return false;
        }
        ConnectedSecurityStatus other = (ConnectedSecurityStatus)o;
        List<Partition> this$partitions = this.getPartitions();
        List<Partition> other$partitions = other.getPartitions();
        return !(this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Partition> $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        return result;
    }

    public String toString() {
        return "ConnectedSecurityStatus(partitions=" + this.getPartitions() + ")";
    }

    public static class ConnectedSecurityStatusBuilder {
        private ArrayList<Partition> partitions;

        ConnectedSecurityStatusBuilder() {
        }

        public ConnectedSecurityStatusBuilder partition(Partition partition) {
            if (this.partitions == null) {
                this.partitions = new ArrayList();
            }
            this.partitions.add(partition);
            return this;
        }

        public ConnectedSecurityStatusBuilder partitions(Collection<? extends Partition> partitions) {
            if (partitions == null) {
                throw new NullPointerException("partitions cannot be null");
            }
            if (this.partitions == null) {
                this.partitions = new ArrayList();
            }
            this.partitions.addAll(partitions);
            return this;
        }

        public ConnectedSecurityStatusBuilder clearPartitions() {
            if (this.partitions != null) {
                this.partitions.clear();
            }
            return this;
        }

        public ConnectedSecurityStatus build() {
            List<Partition> partitions;
            switch (this.partitions == null ? 0 : this.partitions.size()) {
                case 0: {
                    partitions = Collections.emptyList();
                    break;
                }
                case 1: {
                    partitions = Collections.singletonList(this.partitions.get(0));
                    break;
                }
                default: {
                    partitions = Collections.unmodifiableList(new ArrayList<Partition>(this.partitions));
                }
            }
            return new ConnectedSecurityStatus(partitions);
        }

        public String toString() {
            return "ConnectedSecurityStatus.ConnectedSecurityStatusBuilder(partitions=" + this.partitions + ")";
        }
    }

    public static final class Partition {
        private final int mode;
        private final int status;

        public Partition(int mode, int status) {
            this.mode = mode;
            this.status = status;
        }

        public int getMode() {
            return this.mode;
        }

        public int getStatus() {
            return this.status;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Partition)) {
                return false;
            }
            Partition other = (Partition)o;
            if (this.getMode() != other.getMode()) {
                return false;
            }
            return this.getStatus() == other.getStatus();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMode();
            result = result * 59 + this.getStatus();
            return result;
        }

        public String toString() {
            return "ConnectedSecurityStatus.Partition(mode=" + this.getMode() + ", status=" + this.getStatus() + ")";
        }
    }
}

