/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes.properties;

import com.digitaldan.jomnilinkII.MessageTypes.ObjectProperties;

public final class AreaProperties
extends ObjectProperties {
    private final int mode;
    private final int alarms;
    private final int entryTimer;
    private final int exitTimer;
    private final boolean enabled;
    private final int exitDelay;
    private final int entryDelay;

    private AreaProperties(int number, int mode, int alarms, int entryTimer, int exitTimer, boolean enabled, int exitDelay, int entryDelay, String name) {
        super(5, number, name);
        this.mode = mode;
        this.alarms = alarms;
        this.entryTimer = entryTimer;
        this.exitTimer = exitTimer;
        this.enabled = enabled;
        this.exitDelay = exitDelay;
        this.entryDelay = entryDelay;
    }

    public static AreaPropertiesBuilder builder() {
        return new AreaPropertiesBuilder();
    }

    public int getMode() {
        return this.mode;
    }

    public int getAlarms() {
        return this.alarms;
    }

    public int getEntryTimer() {
        return this.entryTimer;
    }

    public int getExitTimer() {
        return this.exitTimer;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getExitDelay() {
        return this.exitDelay;
    }

    public int getEntryDelay() {
        return this.entryDelay;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AreaProperties)) {
            return false;
        }
        AreaProperties other = (AreaProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMode() != other.getMode()) {
            return false;
        }
        if (this.getAlarms() != other.getAlarms()) {
            return false;
        }
        if (this.getEntryTimer() != other.getEntryTimer()) {
            return false;
        }
        if (this.getExitTimer() != other.getExitTimer()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getExitDelay() != other.getExitDelay()) {
            return false;
        }
        return this.getEntryDelay() == other.getEntryDelay();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AreaProperties;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getMode();
        result = result * 59 + this.getAlarms();
        result = result * 59 + this.getEntryTimer();
        result = result * 59 + this.getExitTimer();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getExitDelay();
        result = result * 59 + this.getEntryDelay();
        return result;
    }

    @Override
    public String toString() {
        return "AreaProperties(super=" + super.toString() + ", mode=" + this.getMode() + ", alarms=" + this.getAlarms() + ", entryTimer=" + this.getEntryTimer() + ", exitTimer=" + this.getExitTimer() + ", enabled=" + this.isEnabled() + ", exitDelay=" + this.getExitDelay() + ", entryDelay=" + this.getEntryDelay() + ")";
    }

    public static class AreaPropertiesBuilder {
        private int number;
        private int mode;
        private int alarms;
        private int entryTimer;
        private int exitTimer;
        private boolean enabled;
        private int exitDelay;
        private int entryDelay;
        private String name;

        AreaPropertiesBuilder() {
        }

        public AreaPropertiesBuilder number(int number) {
            this.number = number;
            return this;
        }

        public AreaPropertiesBuilder mode(int mode) {
            this.mode = mode;
            return this;
        }

        public AreaPropertiesBuilder alarms(int alarms) {
            this.alarms = alarms;
            return this;
        }

        public AreaPropertiesBuilder entryTimer(int entryTimer) {
            this.entryTimer = entryTimer;
            return this;
        }

        public AreaPropertiesBuilder exitTimer(int exitTimer) {
            this.exitTimer = exitTimer;
            return this;
        }

        public AreaPropertiesBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public AreaPropertiesBuilder exitDelay(int exitDelay) {
            this.exitDelay = exitDelay;
            return this;
        }

        public AreaPropertiesBuilder entryDelay(int entryDelay) {
            this.entryDelay = entryDelay;
            return this;
        }

        public AreaPropertiesBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AreaProperties build() {
            return new AreaProperties(this.number, this.mode, this.alarms, this.entryTimer, this.exitTimer, this.enabled, this.exitDelay, this.entryDelay, this.name);
        }

        public String toString() {
            return "AreaProperties.AreaPropertiesBuilder(number=" + this.number + ", mode=" + this.mode + ", alarms=" + this.alarms + ", entryTimer=" + this.entryTimer + ", exitTimer=" + this.exitTimer + ", enabled=" + this.enabled + ", exitDelay=" + this.exitDelay + ", entryDelay=" + this.entryDelay + ", name=" + this.name + ")";
        }
    }
}

