/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes.properties;

import com.digitaldan.jomnilinkII.MessageTypes.ObjectProperties;

public final class ThermostatProperties
extends ObjectProperties {
    private final int status;
    private final int temperature;
    private final int heatSetpoint;
    private final int coolSetpoint;
    private final int mode;
    private final int fan;
    private final int hold;
    private final int thermostatType;

    private ThermostatProperties(int number, int status, int temperature, int heatSetpoint, int coolSetpoint, int mode, int fan, int hold, int thermostatType, String name) {
        super(6, number, name);
        this.status = status;
        this.temperature = temperature;
        this.heatSetpoint = heatSetpoint;
        this.coolSetpoint = coolSetpoint;
        this.mode = mode;
        this.fan = fan;
        this.hold = hold;
        this.thermostatType = thermostatType;
    }

    public static ThermostatPropertiesBuilder builder() {
        return new ThermostatPropertiesBuilder();
    }

    public int getStatus() {
        return this.status;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getHeatSetpoint() {
        return this.heatSetpoint;
    }

    public int getCoolSetpoint() {
        return this.coolSetpoint;
    }

    public int getMode() {
        return this.mode;
    }

    public int getFan() {
        return this.fan;
    }

    public int getHold() {
        return this.hold;
    }

    public int getThermostatType() {
        return this.thermostatType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThermostatProperties)) {
            return false;
        }
        ThermostatProperties other = (ThermostatProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        if (this.getTemperature() != other.getTemperature()) {
            return false;
        }
        if (this.getHeatSetpoint() != other.getHeatSetpoint()) {
            return false;
        }
        if (this.getCoolSetpoint() != other.getCoolSetpoint()) {
            return false;
        }
        if (this.getMode() != other.getMode()) {
            return false;
        }
        if (this.getFan() != other.getFan()) {
            return false;
        }
        if (this.getHold() != other.getHold()) {
            return false;
        }
        return this.getThermostatType() == other.getThermostatType();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ThermostatProperties;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getStatus();
        result = result * 59 + this.getTemperature();
        result = result * 59 + this.getHeatSetpoint();
        result = result * 59 + this.getCoolSetpoint();
        result = result * 59 + this.getMode();
        result = result * 59 + this.getFan();
        result = result * 59 + this.getHold();
        result = result * 59 + this.getThermostatType();
        return result;
    }

    @Override
    public String toString() {
        return "ThermostatProperties(super=" + super.toString() + ", status=" + this.getStatus() + ", temperature=" + this.getTemperature() + ", heatSetpoint=" + this.getHeatSetpoint() + ", coolSetpoint=" + this.getCoolSetpoint() + ", mode=" + this.getMode() + ", fan=" + this.getFan() + ", hold=" + this.getHold() + ", thermostatType=" + this.getThermostatType() + ")";
    }

    public static class ThermostatPropertiesBuilder {
        private int number;
        private int status;
        private int temperature;
        private int heatSetpoint;
        private int coolSetpoint;
        private int mode;
        private int fan;
        private int hold;
        private int thermostatType;
        private String name;

        ThermostatPropertiesBuilder() {
        }

        public ThermostatPropertiesBuilder number(int number) {
            this.number = number;
            return this;
        }

        public ThermostatPropertiesBuilder status(int status) {
            this.status = status;
            return this;
        }

        public ThermostatPropertiesBuilder temperature(int temperature) {
            this.temperature = temperature;
            return this;
        }

        public ThermostatPropertiesBuilder heatSetpoint(int heatSetpoint) {
            this.heatSetpoint = heatSetpoint;
            return this;
        }

        public ThermostatPropertiesBuilder coolSetpoint(int coolSetpoint) {
            this.coolSetpoint = coolSetpoint;
            return this;
        }

        public ThermostatPropertiesBuilder mode(int mode) {
            this.mode = mode;
            return this;
        }

        public ThermostatPropertiesBuilder fan(int fan) {
            this.fan = fan;
            return this;
        }

        public ThermostatPropertiesBuilder hold(int hold) {
            this.hold = hold;
            return this;
        }

        public ThermostatPropertiesBuilder thermostatType(int thermostatType) {
            this.thermostatType = thermostatType;
            return this;
        }

        public ThermostatPropertiesBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ThermostatProperties build() {
            return new ThermostatProperties(this.number, this.status, this.temperature, this.heatSetpoint, this.coolSetpoint, this.mode, this.fan, this.hold, this.thermostatType, this.name);
        }

        public String toString() {
            return "ThermostatProperties.ThermostatPropertiesBuilder(number=" + this.number + ", status=" + this.status + ", temperature=" + this.temperature + ", heatSetpoint=" + this.heatSetpoint + ", coolSetpoint=" + this.coolSetpoint + ", mode=" + this.mode + ", fan=" + this.fan + ", hold=" + this.hold + ", thermostatType=" + this.thermostatType + ", name=" + this.name + ")";
        }
    }
}

