/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes.statuses;

import com.digitaldan.jomnilinkII.MessageTypes.statuses.Status;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ThermostatStatus;

public final class ExtendedThermostatStatus
extends Status {
    private final int currentHumidity;
    private final int humidifySetpoint;
    private final int dehumidifySetpoint;
    private final int outdoorTemperature;
    private final int extendedStatus;
    private final ThermostatStatus thermostatStatus;

    private ExtendedThermostatStatus(int number, int status, int currentTemperature, int heatSetpoint, int coolSetpoint, int systemMode, int fanMode, int holdStatus, int currentHumidity, int humidifySetpoint, int dehumidifySetpoint, int outdoorTemperature, int extendedStatus) {
        super(number);
        this.thermostatStatus = ThermostatStatus.builder().number(number).status(status).currentTemperature(currentTemperature).heatSetpoint(heatSetpoint).coolSetpoint(coolSetpoint).systemMode(systemMode).fanMode(fanMode).holdStatus(holdStatus).build();
        this.currentHumidity = currentHumidity;
        this.humidifySetpoint = humidifySetpoint;
        this.dehumidifySetpoint = dehumidifySetpoint;
        this.outdoorTemperature = outdoorTemperature;
        this.extendedStatus = extendedStatus;
    }

    public static ExtendedThermostatStatusBuilder builder() {
        return new ExtendedThermostatStatusBuilder();
    }

    public int getCurrentHumidity() {
        return this.currentHumidity;
    }

    public int getHumidifySetpoint() {
        return this.humidifySetpoint;
    }

    public int getDehumidifySetpoint() {
        return this.dehumidifySetpoint;
    }

    public int getOutdoorTemperature() {
        return this.outdoorTemperature;
    }

    public int getExtendedStatus() {
        return this.extendedStatus;
    }

    public ThermostatStatus getThermostatStatus() {
        return this.thermostatStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtendedThermostatStatus)) {
            return false;
        }
        ExtendedThermostatStatus other = (ExtendedThermostatStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCurrentHumidity() != other.getCurrentHumidity()) {
            return false;
        }
        if (this.getHumidifySetpoint() != other.getHumidifySetpoint()) {
            return false;
        }
        if (this.getDehumidifySetpoint() != other.getDehumidifySetpoint()) {
            return false;
        }
        if (this.getOutdoorTemperature() != other.getOutdoorTemperature()) {
            return false;
        }
        if (this.getExtendedStatus() != other.getExtendedStatus()) {
            return false;
        }
        ThermostatStatus this$thermostatStatus = this.getThermostatStatus();
        ThermostatStatus other$thermostatStatus = other.getThermostatStatus();
        return !(this$thermostatStatus == null ? other$thermostatStatus != null : !((Object)this$thermostatStatus).equals(other$thermostatStatus));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExtendedThermostatStatus;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCurrentHumidity();
        result = result * 59 + this.getHumidifySetpoint();
        result = result * 59 + this.getDehumidifySetpoint();
        result = result * 59 + this.getOutdoorTemperature();
        result = result * 59 + this.getExtendedStatus();
        ThermostatStatus $thermostatStatus = this.getThermostatStatus();
        result = result * 59 + ($thermostatStatus == null ? 43 : ((Object)$thermostatStatus).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ExtendedThermostatStatus(super=" + super.toString() + ", currentHumidity=" + this.getCurrentHumidity() + ", humidifySetpoint=" + this.getHumidifySetpoint() + ", dehumidifySetpoint=" + this.getDehumidifySetpoint() + ", outdoorTemperature=" + this.getOutdoorTemperature() + ", extendedStatus=" + this.getExtendedStatus() + ", thermostatStatus=" + this.getThermostatStatus() + ")";
    }

    public int getStatus() {
        return this.getThermostatStatus().getStatus();
    }

    public int getCurrentTemperature() {
        return this.getThermostatStatus().getCurrentTemperature();
    }

    public int getHeatSetpoint() {
        return this.getThermostatStatus().getHeatSetpoint();
    }

    public int getCoolSetpoint() {
        return this.getThermostatStatus().getCoolSetpoint();
    }

    public int getSystemMode() {
        return this.getThermostatStatus().getSystemMode();
    }

    public int getFanMode() {
        return this.getThermostatStatus().getFanMode();
    }

    public int getHoldStatus() {
        return this.getThermostatStatus().getHoldStatus();
    }

    @Override
    public int getNumber() {
        return this.getThermostatStatus().getNumber();
    }

    public static class ExtendedThermostatStatusBuilder {
        private int number;
        private int status;
        private int currentTemperature;
        private int heatSetpoint;
        private int coolSetpoint;
        private int systemMode;
        private int fanMode;
        private int holdStatus;
        private int currentHumidity;
        private int humidifySetpoint;
        private int dehumidifySetpoint;
        private int outdoorTemperature;
        private int extendedStatus;

        ExtendedThermostatStatusBuilder() {
        }

        public ExtendedThermostatStatusBuilder number(int number) {
            this.number = number;
            return this;
        }

        public ExtendedThermostatStatusBuilder status(int status) {
            this.status = status;
            return this;
        }

        public ExtendedThermostatStatusBuilder currentTemperature(int currentTemperature) {
            this.currentTemperature = currentTemperature;
            return this;
        }

        public ExtendedThermostatStatusBuilder heatSetpoint(int heatSetpoint) {
            this.heatSetpoint = heatSetpoint;
            return this;
        }

        public ExtendedThermostatStatusBuilder coolSetpoint(int coolSetpoint) {
            this.coolSetpoint = coolSetpoint;
            return this;
        }

        public ExtendedThermostatStatusBuilder systemMode(int systemMode) {
            this.systemMode = systemMode;
            return this;
        }

        public ExtendedThermostatStatusBuilder fanMode(int fanMode) {
            this.fanMode = fanMode;
            return this;
        }

        public ExtendedThermostatStatusBuilder holdStatus(int holdStatus) {
            this.holdStatus = holdStatus;
            return this;
        }

        public ExtendedThermostatStatusBuilder currentHumidity(int currentHumidity) {
            this.currentHumidity = currentHumidity;
            return this;
        }

        public ExtendedThermostatStatusBuilder humidifySetpoint(int humidifySetpoint) {
            this.humidifySetpoint = humidifySetpoint;
            return this;
        }

        public ExtendedThermostatStatusBuilder dehumidifySetpoint(int dehumidifySetpoint) {
            this.dehumidifySetpoint = dehumidifySetpoint;
            return this;
        }

        public ExtendedThermostatStatusBuilder outdoorTemperature(int outdoorTemperature) {
            this.outdoorTemperature = outdoorTemperature;
            return this;
        }

        public ExtendedThermostatStatusBuilder extendedStatus(int extendedStatus) {
            this.extendedStatus = extendedStatus;
            return this;
        }

        public ExtendedThermostatStatus build() {
            return new ExtendedThermostatStatus(this.number, this.status, this.currentTemperature, this.heatSetpoint, this.coolSetpoint, this.systemMode, this.fanMode, this.holdStatus, this.currentHumidity, this.humidifySetpoint, this.dehumidifySetpoint, this.outdoorTemperature, this.extendedStatus);
        }

        public String toString() {
            return "ExtendedThermostatStatus.ExtendedThermostatStatusBuilder(number=" + this.number + ", status=" + this.status + ", currentTemperature=" + this.currentTemperature + ", heatSetpoint=" + this.heatSetpoint + ", coolSetpoint=" + this.coolSetpoint + ", systemMode=" + this.systemMode + ", fanMode=" + this.fanMode + ", holdStatus=" + this.holdStatus + ", currentHumidity=" + this.currentHumidity + ", humidifySetpoint=" + this.humidifySetpoint + ", dehumidifySetpoint=" + this.dehumidifySetpoint + ", outdoorTemperature=" + this.outdoorTemperature + ", extendedStatus=" + this.extendedStatus + ")";
        }
    }
}

