/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.routing;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.Contract;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
public class DistributedProxySelector
extends ProxySelector {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedProxySelector.class);
    private final List<ProxySelector> selectors;
    private final ThreadLocal<ProxySelector> currentSelector;
    private final AtomicInteger sharedIndex;

    public DistributedProxySelector(List<ProxySelector> selectors) {
        if (selectors == null || selectors.isEmpty()) {
            throw new IllegalArgumentException("At least one ProxySelector is required");
        }
        this.selectors = new ArrayList<ProxySelector>(selectors);
        this.currentSelector = new ThreadLocal();
        this.sharedIndex = new AtomicInteger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Proxy> select(URI uri) {
        List<Proxy> result = Collections.emptyList();
        for (int i = 0; i < this.selectors.size(); ++i) {
            ProxySelector selector = this.nextSelector();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting next proxy selector for URI {}: {}", (Object)uri, (Object)selector);
            }
            try {
                this.currentSelector.set(selector);
                result = this.currentSelector.get().select(uri);
                if (result.isEmpty()) continue;
                break;
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Exception caught while selecting proxy for URI {}: {}", (Object)uri, (Object)e.getMessage());
                continue;
            }
            finally {
                this.currentSelector.remove();
            }
        }
        return result;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        ProxySelector selector = this.currentSelector.get();
        if (selector != null) {
            selector.connectFailed(uri, sa, ioe);
            this.currentSelector.remove();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removed the current ProxySelector for URI {}: {}", (Object)uri, (Object)selector);
            }
        }
    }

    private ProxySelector nextSelector() {
        int nextIndex = this.sharedIndex.getAndUpdate(i -> (i + 1) % this.selectors.size());
        return this.selectors.get(nextIndex);
    }
}

