/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.converters;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.beanutils.Converter;
import org.dozer.MappingException;
import org.dozer.converters.ConversionException;

public class XMLGregorianCalendarConverter
implements Converter {
    private DateFormat dateFormat;
    private static DatatypeFactory dataTypeFactory;

    public XMLGregorianCalendarConverter(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    private static DatatypeFactory dataTypeFactory() {
        if (dataTypeFactory == null) {
            try {
                dataTypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new MappingException(e);
            }
        }
        return dataTypeFactory;
    }

    public Object convert(Class destClass, Object srcObj) {
        Class<?> sourceClass = srcObj.getClass();
        GregorianCalendar result = new GregorianCalendar();
        if (Date.class.isAssignableFrom(sourceClass)) {
            result.setTime((Date)Date.class.cast(srcObj));
        } else if (Calendar.class.isAssignableFrom(sourceClass)) {
            Calendar c = (Calendar)Calendar.class.cast(srcObj);
            result.setTime(c.getTime());
            ((Calendar)result).setTimeZone(c.getTimeZone());
        } else if (XMLGregorianCalendar.class.isAssignableFrom(sourceClass)) {
            result = ((XMLGregorianCalendar)XMLGregorianCalendar.class.cast(srcObj)).toGregorianCalendar();
        } else {
            if (this.dateFormat != null && String.class.isAssignableFrom(sourceClass)) {
                if ("".equals(String.class.cast(srcObj))) {
                    return null;
                }
                try {
                    long time = this.dateFormat.parse((String)String.class.cast(srcObj)).getTime();
                    result.setTime(new Date(time));
                }
                catch (ParseException e) {
                    throw new ConversionException("Unable to parse source object using specified date format", e);
                }
            }
            try {
                long time = Long.parseLong(srcObj.toString());
                result.setTime(new Date(time));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Unable to determine time in millis of source object", e);
            }
        }
        if (this.dateFormat != null && String.class.isAssignableFrom(destClass)) {
            return this.dateFormat.format(result.getTime());
        }
        return XMLGregorianCalendarConverter.dataTypeFactory().newXMLGregorianCalendar((GregorianCalendar)GregorianCalendar.class.cast(result));
    }
}

