/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.loader.xml;

import com.github.dozermapper.core.MappingException;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.util.DozerClassLoader;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

@Deprecated
public class DozerResolver
implements EntityResolver {
    private final Logger log = LoggerFactory.getLogger(DozerResolver.class);
    private static final String VERSION_5_XSD = "http://dozer.sourceforge.net/schema/beanmapping.xsd";
    private static final String VERSION_6_XSD = "https://dozermapper.github.io/schema/bean-mapping.xsd";
    private final BeanContainer beanContainer;

    public DozerResolver(BeanContainer beanContainer) {
        this.beanContainer = beanContainer;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource source = null;
        this.log.debug("Trying to resolve XML entity with public ID [{}] and system ID [{}]", (Object)publicId, (Object)systemId);
        if (VERSION_5_XSD.equalsIgnoreCase(systemId)) {
            throw new MappingException("Dozer >= v6.0.0 uses a new XSD location. Your current config needs to be upgraded. Found v5 XSD: 'http://dozer.sourceforge.net/schema/beanmapping.xsd'. Expected v6 XSD: 'https://dozermapper.github.io/schema/bean-mapping.xsd'. Please see migration guide @ https://dozermapper.github.io/gitbook");
        }
        try {
            source = this.resolveFromClassPath(publicId, systemId);
        }
        catch (IOException ex1) {
            this.log.error("Could not resolve bean-mapping XML Schema [" + systemId + "]: not found in classpath", (Throwable)ex1);
            try {
                source = this.resolveFromURL(systemId);
            }
            catch (IOException ex2) {
                this.log.error("Could not resolve bean-mapping XML Schema [" + systemId + "]", (Throwable)ex2);
            }
        }
        return source;
    }

    private InputSource resolveFromClassPath(String publicId, String systemId) throws IOException {
        InputSource source = null;
        if (systemId != null && systemId.indexOf("bean-mapping.xsd") > systemId.lastIndexOf("/")) {
            String fileName = String.join((CharSequence)"/", "schema", systemId.substring(systemId.indexOf("bean-mapping.xsd")));
            this.log.debug("Trying to locate [{}] in classpath", (Object)fileName);
            DozerClassLoader classLoader = this.beanContainer.getClassLoader();
            URL url = classLoader.loadResource(fileName);
            try {
                if (url == null) {
                    throw new IOException("URL is null. Failed to find '" + fileName + "' via DozerClassLoader.loadResource");
                }
                source = new InputSource(url.openStream());
                source.setPublicId(publicId);
                source.setSystemId(systemId);
            }
            catch (IOException ex) {
                throw new IOException("Could not resolve bean-mapping XML Schema [" + systemId + "]: not found in classpath; " + fileName, ex);
            }
            this.log.debug("Found bean-mapping XML Schema [{}] in classpath", (Object)systemId);
        }
        return source;
    }

    private InputSource resolveFromURL(String systemId) throws IOException {
        this.log.debug("Trying to download [{}]", (Object)systemId);
        URL obj = new URL(systemId);
        HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
        int status = conn.getResponseCode();
        if (status != 200 && (status == 302 || status == 301 || status == 303)) {
            this.log.debug("Received status of {}, attempting to follow Location header", (Object)status);
            String newUrl = conn.getHeaderField("Location");
            conn = (HttpURLConnection)new URL(newUrl).openConnection();
        }
        return new InputSource(conn.getInputStream());
    }
}

