/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.copiers;

import com.github.trang.copiers.cglib.BeanToMapCopier;
import com.github.trang.copiers.cglib.CglibCopier;
import com.github.trang.copiers.cglib.MapToBeanCopier;
import com.github.trang.copiers.inter.Copier;
import com.github.trang.copiers.mapper.MapperCopier;
import com.github.trang.copiers.mapper.MapperCopierSupport;
import java.util.List;
import java.util.Map;

public final class Copiers {
    private Copiers() {
        throw new UnsupportedOperationException();
    }

    public static <F, T> Copier<F, T> create(Class<F> sourceClass, Class<T> targetClass) {
        return new MapperCopier<F, T>(sourceClass, targetClass);
    }

    public static <F, T> MapperCopierSupport<F, T> createMapper(Class<F> sourceClass, Class<T> targetClass) {
        return new MapperCopierSupport<F, T>(sourceClass, targetClass);
    }

    public static <F, T> Copier<F, T> createCglib(Class<F> sourceClass, Class<T> targetClass) {
        return new CglibCopier<F, T>(sourceClass, targetClass);
    }

    public static <T> Map<String, Object> beanToMap(T bean) {
        return new BeanToMapCopier().copy(bean);
    }

    public static <T> void beanToMap(T bean, Map<String, Object> map) {
        new BeanToMapCopier<T>().copy(bean, map);
    }

    public static <T> List<Map<String, Object>> beansToMap(List<T> list) {
        return new BeanToMapCopier<T>().map(list);
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> beanClass) {
        return new MapToBeanCopier<T>(beanClass).copy(map);
    }

    public static <T> void mapToBean(Map<String, Object> map, T bean) {
        Class<?> beanClass = bean.getClass();
        new MapToBeanCopier(beanClass).copy(map, bean);
    }

    public static <T> List<T> mapToBeans(List<Map<String, Object>> list, Class<T> beanClass) {
        return new MapToBeanCopier<T>(beanClass).map(list);
    }
}

