/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.copiers.adapter;

import com.github.trang.copiers.inter.Copier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class CopierAdapter<C, F, T>
implements Copier<F, T> {
    protected C copier;
    protected Class<F> sourceClass;
    protected Class<T> targetClass;

    protected CopierAdapter() {
    }

    protected CopierAdapter(Class<F> sourceClass, Class<T> targetClass, C copier) {
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
        this.copier = copier;
    }

    @Override
    public List<T> map(List<F> sourceList) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList targetList = new ArrayList(sourceList.size());
        for (F source : sourceList) {
            targetList.add(this.copy(source));
        }
        return targetList;
    }

    protected void checkNull(Object o, String msg) {
        if (o == null) {
            throw new NullPointerException(msg);
        }
    }

    protected void checkNull(Map map, String msg) {
        if (map == null || map.isEmpty()) {
            throw new NullPointerException(msg);
        }
    }
}

