/*
 * Decompiled with CFR 0.152.
 */
package com.github.edwgiz.mavenShadePlugin.log4j2CacheTransformer;

import com.github.edwgiz.mavenShadePlugin.log4j2CacheTransformer.CloseShieldOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.core.config.plugins.processor.PluginCache;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;

public class PluginsCacheFileTransformer
implements ResourceTransformer {
    private final ArrayList<File> tempFiles = new ArrayList();
    private final List<Relocator> relocators = new ArrayList<Relocator>();

    public boolean canTransformResource(String resource) {
        return resource != null && "META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat".equals(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        File tempFile = File.createTempFile("Log4j2Plugins", "dat");
        FileOutputStream fos = new FileOutputStream(tempFile);
        try {
            IOUtils.copyLarge((InputStream)is, (OutputStream)fos);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fos);
        }
        this.tempFiles.add(tempFile);
        if (relocators != null) {
            this.relocators.addAll(relocators);
        }
    }

    public boolean hasTransformedResource() {
        return this.tempFiles.size() > 1 || this.tempFiles.size() > 0 && this.relocators.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        try {
            PluginCache aggregator = new PluginCache();
            aggregator.loadCacheFiles(this.getUrls());
            this.relocatePlugin(aggregator, this.relocators);
            jos.putNextEntry(new JarEntry("META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat"));
            aggregator.writeCache((OutputStream)((Object)new CloseShieldOutputStream(jos)));
        }
        finally {
            ListIterator<File> it = this.tempFiles.listIterator();
            while (it.hasNext()) {
                File f = it.next();
                f.delete();
                it.remove();
            }
        }
    }

    void relocatePlugin(PluginCache aggregator, List<Relocator> relocators) {
        for (Map.Entry categoryEntry : aggregator.getAllCategories().entrySet()) {
            for (Map.Entry pluginMapEntry : ((Map)categoryEntry.getValue()).entrySet()) {
                PluginEntry pluginEntry = (PluginEntry)pluginMapEntry.getValue();
                String originalClassName = pluginEntry.getClassName();
                Relocator matchingRelocator = this.findFirstMatchingRelocator(originalClassName, relocators);
                if (matchingRelocator == null) continue;
                String newClassName = matchingRelocator.relocateClass(originalClassName);
                pluginEntry.setClassName(newClassName);
            }
        }
    }

    private Relocator findFirstMatchingRelocator(String originalClassName, List<Relocator> relocators) {
        for (Relocator relocator : relocators) {
            if (!relocator.canRelocateClass(originalClassName)) continue;
            return relocator;
        }
        return null;
    }

    private Enumeration<URL> getUrls() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File tempFile : this.tempFiles) {
            URL url = tempFile.toURI().toURL();
            urls.add(url);
        }
        return Collections.enumeration(urls);
    }
}

