/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.NodeVersionDetector;
import com.github.eirslett.maven.plugins.frontend.lib.NodeVersionHelper;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import java.io.File;
import java.util.Objects;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInstallNodeMojo
extends AbstractFrontendMojo {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractInstallNodeMojo.class);
    @Parameter(property="nodeDownloadRoot", required=false)
    protected String nodeDownloadRoot;
    @Parameter(property="nodeVersion", defaultValue="", required=false)
    protected String nodeVersion;
    @Parameter(property="nodeVersionFile", defaultValue="", required=false)
    protected String nodeVersionFile;

    @Override
    protected void execute(FrontendPluginFactory factory) throws Exception {
        this.verifyAndResolveNodeVersion(factory);
        this.executeWithVerifiedNodeVersion(factory);
    }

    protected abstract void executeWithVerifiedNodeVersion(FrontendPluginFactory var1) throws Exception;

    private void verifyAndResolveNodeVersion(FrontendPluginFactory factory) throws Exception {
        String nodeVersion;
        if (factory.isVersionManagerAvailable() && this.nodeVersion != null && !this.nodeVersion.isEmpty()) {
            logger.warn("`nodeVersion` has been configured to {} but will be ignored when installing with node version manager. Version Manager will load the version from their version file (e.g. .nvmrc, .tool-versions)", (Object)this.nodeVersion);
        }
        if (Objects.isNull(nodeVersion = NodeVersionDetector.getNodeVersion((File)this.workingDirectory, (String)this.nodeVersion, (String)this.nodeVersionFile))) {
            throw new LifecycleExecutionException("Node version could not be detected from a file and was not set");
        }
        if (!NodeVersionHelper.validateVersion((String)nodeVersion)) {
            throw new LifecycleExecutionException("Node version (" + nodeVersion + ") is not valid. If you think it actually is, raise an issue");
        }
        String validNodeVersion = NodeVersionHelper.getDownloadableVersion((String)nodeVersion);
        logger.info("Resolved Node version: {}", (Object)validNodeVersion);
        this.nodeVersion = validNodeVersion;
    }
}

