/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsReporter;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.NodeVersionDetector;
import com.github.eirslett.maven.plugins.frontend.lib.NodeVersionHelper;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="ember", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class EmberMojo
extends AbstractFrontendMojo {
    @Parameter(property="frontend.ember.arguments")
    private String arguments;
    @Parameter(property="nodeVersion", defaultValue="", required=false)
    private String nodeVersion;
    @Parameter(property="nodeVersionFile", defaultValue="", required=false)
    private String nodeVersionFile;
    @Parameter(property="triggerfiles")
    private List<File> triggerfiles;
    @Parameter(property="srcdir")
    private File srcdir;
    @Parameter(property="outputdir")
    private File outputdir;
    @Parameter(property="skip.ember", defaultValue="${skip.ember}")
    private boolean skip;
    @Component
    private BuildContext buildContext;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public synchronized void execute(FrontendPluginFactory factory) throws Exception {
        boolean incrementalEnabled = MojoUtils.incrementalBuildEnabled(this.buildContext);
        boolean shouldExecute = this.shouldExecute();
        AtlassianDevMetricsReporter.incrementExecutionCount((String)this.project.getArtifactId(), (String)this.arguments, (AtlassianDevMetricsReporter.Goal)AtlassianDevMetricsReporter.Goal.EMBER, (String)this.getFrontendMavenPluginVersion(), (boolean)incrementalEnabled, (!shouldExecute ? 1 : 0) != 0, () -> {
            if (shouldExecute) {
                String nodeVersion = NodeVersionDetector.getNodeVersion((File)this.workingDirectory, (String)this.nodeVersion, (String)this.nodeVersionFile, (String)this.project.getArtifactId(), (String)this.getFrontendMavenPluginVersion());
                if (Objects.isNull(nodeVersion)) {
                    throw new LifecycleExecutionException("Node version could not be detected from a file and was not set");
                }
                if (!NodeVersionHelper.validateVersion((String)nodeVersion)) {
                    throw new LifecycleExecutionException("Node version (" + nodeVersion + ") is not valid. If you think it actually is, raise an issue");
                }
                String validNodeVersion = NodeVersionHelper.getDownloadableVersion((String)nodeVersion);
                factory.loadNodeVersionManager(validNodeVersion);
                factory.getEmberRunner().execute(this.arguments, this.environmentVariables);
                if (this.outputdir != null) {
                    this.getLog().info((CharSequence)("Refreshing files after ember: " + this.outputdir));
                    this.buildContext.refresh(this.outputdir);
                }
            } else {
                this.getLog().info((CharSequence)("Skipping ember as no modified files in " + this.srcdir));
            }
        });
    }

    private boolean shouldExecute() {
        if (this.triggerfiles == null || this.triggerfiles.isEmpty()) {
            this.triggerfiles = Arrays.asList(new File(this.workingDirectory, "Gruntfile.js"));
        }
        return MojoUtils.shouldExecute(this.buildContext, this.triggerfiles, this.srcdir);
    }
}

