/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultFileDownloader
implements FileDownloader {
    private final ProxyConfig proxy;

    public DefaultFileDownloader(ProxyConfig proxy) {
        this.proxy = proxy;
    }

    @Override
    public void download(String downloadUrl, String destination) throws DownloadException {
        try {
            URI downloadURI = new URI(downloadUrl);
            if ("file".equalsIgnoreCase(downloadURI.getScheme())) {
                FileUtils.copyFile((File)new File(downloadURI), (File)new File(destination));
            } else {
                CloseableHttpResponse response = this.execute(downloadUrl);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new DownloadException("Got error code " + statusCode + " from the server.");
                }
                new File(FilenameUtils.getFullPathNoEndSeparator((String)destination)).mkdirs();
                ReadableByteChannel rbc = Channels.newChannel(response.getEntity().getContent());
                FileOutputStream fos = new FileOutputStream(destination);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                fos.close();
            }
        }
        catch (IOException e) {
            throw new DownloadException("Could not download " + downloadUrl, e);
        }
        catch (URISyntaxException e) {
            throw new DownloadException("Could not download " + downloadUrl, e);
        }
    }

    private CloseableHttpResponse execute(String requestUrl) throws IOException {
        Logger logger = LoggerFactory.getLogger(FileDownloader.class);
        if (this.proxy != null) {
            logger.info("Downloading via proxy " + this.proxy.toString());
            return this.executeViaProxy(requestUrl);
        }
        logger.info("No proxy was configured, downloading directly");
        CloseableHttpResponse response = HttpClients.createDefault().execute((HttpUriRequest)new HttpGet(requestUrl));
        return response;
    }

    private CloseableHttpResponse executeViaProxy(String requestUrl) throws IOException {
        CloseableHttpClient proxyClient;
        if (this.proxy.useAuthentication()) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.proxy.host, this.proxy.port), (Credentials)new UsernamePasswordCredentials(this.proxy.username, this.proxy.password));
            proxyClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        } else {
            proxyClient = HttpClients.createDefault();
        }
        HttpHost proxyHttpHost = new HttpHost(this.proxy.host, this.proxy.port, this.proxy.protocol);
        RequestConfig requestConfig = RequestConfig.custom().setProxy(proxyHttpHost).build();
        HttpGet request = new HttpGet(requestUrl);
        request.setConfig(requestConfig);
        return proxyClient.execute((HttpUriRequest)request);
    }
}

