/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.Architecture;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractionException;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.BunExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.CacheDescriptor;
import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.InstallBunExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.OS;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutionException;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BunInstaller {
    public static final String INSTALL_PATH = "/bun";
    public static final String DEFAULT_BUN_DOWNLOAD_ROOT = "https://github.com/oven-sh/bun/releases/download/";
    private static final Object LOCK = new Object();
    private String bunVersion;
    private String userName;
    private String password;
    private Map<String, String> httpHeaders;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstallConfig config;
    private final ArchiveExtractor archiveExtractor;
    private final FileDownloader fileDownloader;

    BunInstaller(InstallConfig config, ArchiveExtractor archiveExtractor, FileDownloader fileDownloader) {
        this.config = config;
        this.archiveExtractor = archiveExtractor;
        this.fileDownloader = fileDownloader;
    }

    public BunInstaller setBunVersion(String bunVersion) {
        this.bunVersion = bunVersion;
        return this;
    }

    public BunInstaller setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public BunInstaller setPassword(String password) {
        this.password = password;
        return this;
    }

    public BunInstaller setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() throws InstallationException {
        Object object = LOCK;
        synchronized (object) {
            if (!this.bunIsAlreadyInstalled()) {
                if (!this.bunVersion.startsWith("v")) {
                    this.logger.warn("Bun version does not start with naming convention 'v'.");
                }
                this.installBunDefault();
            }
        }
    }

    private boolean bunIsAlreadyInstalled() {
        try {
            InstallBunExecutorConfig executorConfig = new InstallBunExecutorConfig(this.config);
            File bunFile = executorConfig.getBunPath();
            if (bunFile.exists()) {
                String version = new BunExecutor(executorConfig, Arrays.asList("--version"), null).executeAndGetResult(this.logger);
                if (version.equals(this.bunVersion.replaceFirst("^v", ""))) {
                    this.logger.info("Bun {} is already installed.", (Object)version);
                    return true;
                }
                this.logger.info("Bun {} was installed, but we need version {}", (Object)version, (Object)this.bunVersion);
                return false;
            }
            return false;
        }
        catch (ProcessExecutionException e) {
            this.logger.warn("Unable to determine current bun version: {}", (Object)e.getMessage());
            return false;
        }
    }

    private void installBunDefault() throws InstallationException {
        try {
            this.logger.info("Installing Bun version {}", (Object)this.bunVersion);
            String downloadUrl = this.createDownloadUrl();
            CacheDescriptor cacheDescriptor = new CacheDescriptor("bun", this.bunVersion, "zip");
            File archive = this.config.getCacheResolver().resolve(cacheDescriptor);
            this.downloadFileIfMissing(downloadUrl, archive, this.userName, this.password, this.httpHeaders);
            File installDirectory = this.getInstallDirectory();
            File bunExtractDirectory = new File(installDirectory, this.createBunTargetArchitecturePath());
            try {
                if (bunExtractDirectory.isDirectory()) {
                    FileUtils.deleteDirectory((File)bunExtractDirectory);
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete existing Bun installation.");
            }
            try {
                this.extractFile(archive, installDirectory);
            }
            catch (ArchiveExtractionException e) {
                if (e.getCause() instanceof EOFException) {
                    this.logger.error("The archive file {} is corrupted and will be deleted. Please try the build again.", (Object)archive.getPath());
                    archive.delete();
                }
                throw e;
            }
            String bunExecutable = this.config.getPlatform().isWindows() ? "bun.exe" : "bun";
            File bunBinary = new File(installDirectory, File.separator + this.createBunTargetArchitecturePath() + File.separator + bunExecutable);
            if (!bunBinary.exists()) {
                throw new FileNotFoundException("Could not find the downloaded bun binary in " + bunBinary);
            }
            File destinationDirectory = new File(this.getInstallDirectory(), INSTALL_PATH);
            if (!destinationDirectory.exists()) {
                this.logger.info("Creating destination directory {}", (Object)destinationDirectory);
                destinationDirectory.mkdirs();
            }
            File destination = new File(destinationDirectory, bunExecutable);
            this.logger.info("Copying bun binary from {} to {}", (Object)bunBinary, (Object)destination);
            if (destination.exists() && !destination.delete()) {
                throw new InstallationException("Could not install Bun: Was not allowed to delete " + destination);
            }
            try {
                Files.move(bunBinary.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new InstallationException("Could not install Bun: Was not allowed to rename " + bunBinary + " to " + destination);
            }
            if (!destination.setExecutable(true, false)) {
                throw new InstallationException("Could not install Bun: Was not allowed to make " + destination + " executable.");
            }
            FileUtils.deleteDirectory((File)bunExtractDirectory);
            this.logger.info("Installed bun locally.");
        }
        catch (IOException e) {
            throw new InstallationException("Could not install bun", e);
        }
        catch (DownloadException e) {
            throw new InstallationException("Could not download bun", e);
        }
        catch (ArchiveExtractionException e) {
            throw new InstallationException("Could not extract the bun archive", e);
        }
    }

    private String createDownloadUrl() {
        String downloadUrl = String.format("%sbun-%s", DEFAULT_BUN_DOWNLOAD_ROOT, this.bunVersion);
        String extension = "zip";
        String fileending = String.format("%s.%s", this.createBunTargetArchitecturePath(), extension);
        downloadUrl = downloadUrl + fileending;
        return downloadUrl;
    }

    private String createBunTargetArchitecturePath() {
        String destOs;
        OS os = OS.guess();
        Architecture architecture = Architecture.guess();
        String string = os.equals((Object)OS.Linux) ? "linux" : (os.equals((Object)OS.Mac) ? "darwin" : (destOs = os.equals((Object)OS.Windows) ? "windows" : null));
        String destArc = architecture.equals((Object)Architecture.x64) ? "x64" : (architecture.equals((Object)Architecture.arm64) ? "aarch64" : null);
        return String.format("%s-%s-%s", INSTALL_PATH, destOs, destArc);
    }

    private File getInstallDirectory() {
        File installDirectory = new File(this.config.getInstallDirectory(), "/");
        if (!installDirectory.exists()) {
            this.logger.info("Creating install directory {}", (Object)installDirectory);
            installDirectory.mkdirs();
        }
        return installDirectory;
    }

    private void extractFile(File archive, File destinationDirectory) throws ArchiveExtractionException {
        this.logger.info("Unpacking {} into {}", (Object)archive, (Object)destinationDirectory);
        this.archiveExtractor.extract(archive.getPath(), destinationDirectory.getPath());
    }

    private void downloadFileIfMissing(String downloadUrl, File destination, String userName, String password, Map<String, String> httpHeaders) throws DownloadException {
        if (!destination.exists()) {
            this.downloadFile(downloadUrl, destination, userName, password, httpHeaders);
        }
    }

    private void downloadFile(String downloadUrl, File destination, String userName, String password, Map<String, String> httpHeaders) throws DownloadException {
        this.logger.info("Downloading {} to {}", (Object)downloadUrl, (Object)destination);
        this.fileDownloader.download(downloadUrl, destination.getPath(), userName, password, httpHeaders);
    }
}

