/*
 * Decompiled with CFR 0.152.
 */
package org.exampledriven;

import java.util.Locale;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.repository.RepositorySystem;

@Mojo(name="tree")
public class HierarchyMojo
extends AbstractMojo {
    private static final int DEPTH_INCREMENT = 2;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="level")
    private String level;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ProjectBuilder projectBuilder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String message = "Displaying hierarchy. ";
        if (!this.isLevelFull()) {
            message = message + "Set level=full to display dependencies in dependencyManagement";
        }
        this.getLog().info((CharSequence)message);
        if (!this.processParentAndImportsRecursive(this.project, 1)) {
            this.getLog().info((CharSequence)"Project has no parent and imported poms either.");
        }
    }

    private boolean processParentAndImportsRecursive(MavenProject currentProject, int depth) {
        boolean hasImports;
        boolean hasParent = this.processParentRecursive(currentProject.getParent(), depth);
        if (this.isLevelFull()) {
            this.displayManagedDependencies(currentProject, depth);
        }
        return (hasImports = this.processImportsRecursive(currentProject, depth)) || hasParent;
    }

    private boolean isLevelFull() {
        return "full".equals(this.level);
    }

    private void displayManagedDependencies(MavenProject currentProject, int depth) {
        DependencyManagement dependencyManagement = currentProject.getDependencyManagement();
        if (dependencyManagement != null) {
            for (Dependency dependency : dependencyManagement.getDependencies()) {
                this.logDependency(MessageType.DEP_MANAGEMENT, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), depth + 4);
            }
        }
    }

    private boolean processParentRecursive(MavenProject parent, int depth) {
        if (parent != null) {
            this.logDependency(MessageType.PARENT, parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), depth);
            this.processParentAndImportsRecursive(parent, depth + 2);
        }
        return parent != null;
    }

    private boolean processImportsRecursive(MavenProject currentProject, int depth) {
        DependencyManagement dependencyManagement = currentProject.getOriginalModel().getDependencyManagement();
        if (dependencyManagement != null) {
            for (Dependency dependency : dependencyManagement.getDependencies()) {
                MavenProject mavenProject;
                if (!"import".equals(dependency.getScope()) || !"pom".equals(dependency.getType())) continue;
                try {
                    mavenProject = this.getMavenProject(currentProject, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
                }
                catch (ProjectBuildingException e) {
                    throw new RuntimeException(e);
                }
                this.logDependency(MessageType.IMPORT, mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion(), depth);
                this.processParentAndImportsRecursive(mavenProject, depth + 2);
            }
        }
        return dependencyManagement != null;
    }

    private MavenProject getMavenProject(MavenProject currentProject, String groupId, String artifactId, String version) throws ProjectBuildingException {
        String resolvedVersion = this.resolveVersionProperty(currentProject, version);
        Artifact pomArtifact = this.repositorySystem.createProjectArtifact(groupId, artifactId, resolvedVersion);
        return this.projectBuilder.build(pomArtifact, this.session.getProjectBuildingRequest()).getProject();
    }

    private String resolveVersionProperty(MavenProject currentProject, String version) {
        if (this.isVersionSetAsProperty(version)) {
            String propertyName = version.replace("$", "").replace("{", "").replace("}", "");
            return this.findPropertyRecursively(currentProject, propertyName);
        }
        return version;
    }

    private String findPropertyRecursively(MavenProject mavenProject, String propertyName) {
        String propertyValue;
        Properties properties = mavenProject.getProperties();
        if (properties != null && (propertyValue = (String)properties.get(propertyName)) != null) {
            return propertyValue;
        }
        MavenProject parent = mavenProject.getParent();
        if (parent != null) {
            return this.findPropertyRecursively(parent, propertyName);
        }
        return propertyName;
    }

    private boolean isVersionSetAsProperty(String version) {
        return version.contains("${");
    }

    private void logDependency(MessageType messageType, String groupId, String artifactId, String version, int indentation) {
        String projectString = String.format(Locale.US, "%s:%s:%s", groupId, artifactId, version);
        String shift = String.format("%0" + indentation + "d", 0).replace("0", " ");
        this.getLog().info((CharSequence)(shift + messageType.name() + " " + projectString));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MessageType {
        PARENT,
        IMPORT,
        DEP_MANAGEMENT;

    }
}

