/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency.gml;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.github.ferstl.depgraph.dependency.VersionAbbreviator;
import com.github.ferstl.depgraph.graph.EdgeRenderer;

public class GmlDependencyEdgeRenderer
implements EdgeRenderer<DependencyNode> {
    private final boolean renderVersion;

    public GmlDependencyEdgeRenderer(boolean renderVersion) {
        this.renderVersion = renderVersion;
    }

    @Override
    public String render(DependencyNode from, DependencyNode to) {
        NodeResolution resolution = to.getResolution();
        StringBuilder builder = new StringBuilder();
        if (resolution == NodeResolution.OMITTED_FOR_CONFLICT) {
            String version = "";
            if (this.renderVersion) {
                version = VersionAbbreviator.abbreviateVersion(to.getArtifact().getVersion());
            }
            GmlDependencyEdgeRenderer.addStyleAttributes(builder, version, "dashed", "#FF0000");
        } else if (resolution == NodeResolution.OMITTED_FOR_DUPLICATE) {
            GmlDependencyEdgeRenderer.addStyleAttributes(builder, "", "dotted", "");
        }
        return builder.toString();
    }

    private static void addStyleAttributes(StringBuilder builder, String label, String edgeStyle, String color) {
        if (!label.isEmpty()) {
            builder.append("label \"").append(label).append("\"");
        }
        builder.append("\n").append("graphics\n").append("[\n").append("style \"").append(edgeStyle).append("\"").append("\n").append("targetArrow \"").append("standard").append("\"");
        if (!color.isEmpty()) {
            builder.append("\n").append("fill \"").append(color).append("\"").append("\n").append("]").append("\n").append("LabelGraphics").append("\n").append("[").append("\n").append("color \"").append(color).append("\"");
        }
        builder.append("\n").append("]");
    }
}

