/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.jts;

import com.github.filosganga.geogson.codec.Codec;
import com.github.filosganga.geogson.jts.JtsLineStringIterable;
import com.github.filosganga.geogson.jts.JtsPointIterable;
import com.github.filosganga.geogson.jts.MultiLineStringCodec;
import com.github.filosganga.geogson.jts.MultiPointCodec;
import com.github.filosganga.geogson.jts.MultiPolygonCodec;
import com.github.filosganga.geogson.model.Coordinates;
import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.GeometryCollection;
import com.github.filosganga.geogson.model.MultiLineString;
import com.github.filosganga.geogson.model.MultiPolygon;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;

public abstract class AbstractJtsCodec<S, T extends Geometry<?>>
implements Codec<S, T> {
    protected final GeometryFactory geometryFactory;

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public AbstractJtsCodec(GeometryFactory geometryFactory) {
        this.geometryFactory = (GeometryFactory)Preconditions.checkNotNull((Object)geometryFactory, (Object)"The geometryFactory cannot be null");
    }

    protected Function<Geometry<?>, com.vividsolutions.jts.geom.Geometry> toJtsGeometryCollectionFn() {
        return new Function<Geometry<?>, com.vividsolutions.jts.geom.Geometry>(){

            public com.vividsolutions.jts.geom.Geometry apply(Geometry<?> input) {
                return AbstractJtsCodec.this.toJtsGeometryCollection(input);
            }
        };
    }

    protected com.vividsolutions.jts.geom.Geometry toJtsGeometryCollection(Geometry<?> src) {
        Point returnGeometry;
        if (src instanceof com.github.filosganga.geogson.model.Point) {
            returnGeometry = AbstractJtsCodec.toJtsPoint((com.github.filosganga.geogson.model.Point)src);
        } else if (src instanceof com.github.filosganga.geogson.model.LineString) {
            returnGeometry = this.toJtsLineString((com.github.filosganga.geogson.model.LineString)src);
        } else if (src instanceof com.github.filosganga.geogson.model.Polygon) {
            returnGeometry = this.toJtsPolygon((com.github.filosganga.geogson.model.Polygon)src);
        } else if (src instanceof com.github.filosganga.geogson.model.MultiPoint) {
            MultiPointCodec codec = new MultiPointCodec(this.geometryFactory);
            MultiPoint multiPoint = (MultiPoint)codec.fromGeometry((Geometry)((com.github.filosganga.geogson.model.MultiPoint)src));
            returnGeometry = multiPoint;
        } else if (src instanceof MultiLineString) {
            MultiLineStringCodec codec = new MultiLineStringCodec(this.geometryFactory);
            com.vividsolutions.jts.geom.MultiLineString multiLineString = (com.vividsolutions.jts.geom.MultiLineString)codec.fromGeometry((Geometry)((MultiLineString)src));
            returnGeometry = multiLineString;
        } else if (src instanceof MultiPolygon) {
            MultiPolygonCodec codec = new MultiPolygonCodec(this.geometryFactory);
            com.vividsolutions.jts.geom.MultiPolygon multiPolygon = (com.vividsolutions.jts.geom.MultiPolygon)codec.fromGeometry((Geometry)((MultiPolygon)src));
            returnGeometry = multiPolygon;
        } else if (src instanceof GeometryCollection) {
            ArrayList<com.vividsolutions.jts.geom.Geometry> geometries = new ArrayList<com.vividsolutions.jts.geom.Geometry>();
            GeometryCollection geometryCollection = (GeometryCollection)src;
            for (Geometry geometry : geometryCollection.getGeometries()) {
                com.vividsolutions.jts.geom.Geometry jtsGeometry = this.toJtsGeometryCollection(geometry);
                geometries.add(jtsGeometry);
            }
            returnGeometry = this.geometryFactory.createGeometryCollection(geometries.toArray(new com.vividsolutions.jts.geom.Geometry[geometryCollection.size()]));
        } else {
            throw new IllegalArgumentException("Unsupported geometry type: " + src.type());
        }
        return returnGeometry;
    }

    public Function<com.vividsolutions.jts.geom.Geometry, Geometry<?>> fromJtsGeometryCollectionFn() {
        return new Function<com.vividsolutions.jts.geom.Geometry, Geometry<?>>(){

            public Geometry<?> apply(com.vividsolutions.jts.geom.Geometry input) {
                return AbstractJtsCodec.this.fromJtsGeometryCollection(input);
            }
        };
    }

    protected Geometry<?> fromJtsGeometryCollection(com.vividsolutions.jts.geom.Geometry src) {
        com.github.filosganga.geogson.model.Point returnGeometry;
        if (src.getGeometryType().equalsIgnoreCase(Geometry.Type.GEOMETRY_COLLECTION.getValue())) {
            ArrayList geometries = new ArrayList();
            for (int i = 0; i < src.getNumGeometries(); ++i) {
                Geometry<?> geometry = null;
                com.vividsolutions.jts.geom.Geometry jtsGeometry = src.getGeometryN(i);
                geometry = this.fromJtsGeometryCollection(jtsGeometry);
                geometries.add(geometry);
            }
            returnGeometry = GeometryCollection.of(geometries);
        } else if (src.getGeometryType().equalsIgnoreCase(Geometry.Type.POINT.getValue())) {
            returnGeometry = AbstractJtsCodec.fromJtsPoint((Point)src);
        } else if (src.getGeometryType().equalsIgnoreCase(Geometry.Type.LINE_STRING.getValue())) {
            returnGeometry = this.fromJtsLineString((LineString)src);
        } else if (src.getGeometryType().equalsIgnoreCase(Geometry.Type.POLYGON.getValue())) {
            returnGeometry = this.fromJtsPolygon((Polygon)src);
        } else if (src.getGeometryType().equalsIgnoreCase(Geometry.Type.MULTI_POINT.getValue())) {
            MultiPointCodec codec = new MultiPointCodec(this.geometryFactory);
            com.github.filosganga.geogson.model.MultiPoint multiPoint = (com.github.filosganga.geogson.model.MultiPoint)codec.toGeometry((MultiPoint)src);
            returnGeometry = multiPoint;
        } else if (src.getGeometryType().equalsIgnoreCase(Geometry.Type.MULTI_LINE_STRING.getValue())) {
            MultiLineStringCodec codec = new MultiLineStringCodec(this.geometryFactory);
            MultiLineString multiLineString = (MultiLineString)codec.toGeometry((com.vividsolutions.jts.geom.MultiLineString)src);
            returnGeometry = multiLineString;
        } else if (src.getGeometryType().equalsIgnoreCase(Geometry.Type.MULTI_POLYGON.getValue())) {
            MultiPolygonCodec codec = new MultiPolygonCodec(this.geometryFactory);
            MultiPolygon multiPolygon = (MultiPolygon)codec.toGeometry((com.vividsolutions.jts.geom.MultiPolygon)src);
            returnGeometry = multiPolygon;
        } else {
            throw new IllegalArgumentException("Unsupported geometry type: " + src.getGeometryType());
        }
        return returnGeometry;
    }

    protected Function<com.github.filosganga.geogson.model.Polygon, Polygon> toJtsPolygonFn() {
        return new Function<com.github.filosganga.geogson.model.Polygon, Polygon>(){

            public Polygon apply(com.github.filosganga.geogson.model.Polygon input) {
                return AbstractJtsCodec.this.toJtsPolygon(input);
            }
        };
    }

    protected Polygon toJtsPolygon(com.github.filosganga.geogson.model.Polygon src) {
        return this.geometryFactory.createPolygon(this.toJtsLinearRing(src.perimeter()), (LinearRing[])FluentIterable.from((Iterable)src.holes()).transform(this.toJtsLinearRingFn()).toArray(LinearRing.class));
    }

    public Function<Polygon, com.github.filosganga.geogson.model.Polygon> fromJtsPolygonFn() {
        return new Function<Polygon, com.github.filosganga.geogson.model.Polygon>(){

            public com.github.filosganga.geogson.model.Polygon apply(Polygon input) {
                return AbstractJtsCodec.this.fromJtsPolygon(input);
            }
        };
    }

    protected com.github.filosganga.geogson.model.Polygon fromJtsPolygon(Polygon src) {
        return com.github.filosganga.geogson.model.Polygon.of((com.github.filosganga.geogson.model.LinearRing)this.fromJtsLineString(src.getExteriorRing()).toLinearRing(), (Iterable)FluentIterable.from((Iterable)JtsLineStringIterable.forHolesOf(src)).transform(this.fromJtsLineStringFn()).transform(com.github.filosganga.geogson.model.LinearRing.toLinearRingFn()));
    }

    protected Function<com.github.filosganga.geogson.model.LinearRing, LinearRing> toJtsLinearRingFn() {
        return new Function<com.github.filosganga.geogson.model.LinearRing, LinearRing>(){

            public LinearRing apply(com.github.filosganga.geogson.model.LinearRing input) {
                return AbstractJtsCodec.this.toJtsLinearRing(input);
            }
        };
    }

    protected LinearRing toJtsLinearRing(com.github.filosganga.geogson.model.LinearRing src) {
        return this.geometryFactory.createLinearRing((Coordinate[])FluentIterable.from((Iterable)((LinearPositions)src.positions()).children()).transform(SinglePosition.coordinatesFn()).transform(AbstractJtsCodec.toJtsCoordinateFn()).toArray(Coordinate.class));
    }

    protected Function<LinearRing, com.github.filosganga.geogson.model.LinearRing> fromJtsLinearRingFn() {
        return new Function<LinearRing, com.github.filosganga.geogson.model.LinearRing>(){

            public com.github.filosganga.geogson.model.LinearRing apply(LinearRing input) {
                return AbstractJtsCodec.this.fromJtsLinearRing(input);
            }
        };
    }

    protected com.github.filosganga.geogson.model.LinearRing fromJtsLinearRing(LinearRing src) {
        return com.github.filosganga.geogson.model.LinearRing.of((Iterable)Iterables.transform((Iterable)JtsPointIterable.of((LineString)src), AbstractJtsCodec.fromJtsPointFn()));
    }

    protected Function<com.github.filosganga.geogson.model.LineString, LineString> toJtsLineStringFn() {
        return new Function<com.github.filosganga.geogson.model.LineString, LineString>(){

            public LineString apply(com.github.filosganga.geogson.model.LineString input) {
                return AbstractJtsCodec.this.toJtsLineString(input);
            }
        };
    }

    protected LineString toJtsLineString(com.github.filosganga.geogson.model.LineString src) {
        return this.geometryFactory.createLineString((Coordinate[])FluentIterable.from((Iterable)((LinearPositions)src.positions()).children()).transform(SinglePosition.coordinatesFn()).transform(AbstractJtsCodec.toJtsCoordinateFn()).toArray(Coordinate.class));
    }

    protected Function<LineString, com.github.filosganga.geogson.model.LineString> fromJtsLineStringFn() {
        return new Function<LineString, com.github.filosganga.geogson.model.LineString>(){

            public com.github.filosganga.geogson.model.LineString apply(LineString input) {
                return AbstractJtsCodec.this.fromJtsLineString(input);
            }
        };
    }

    protected com.github.filosganga.geogson.model.LineString fromJtsLineString(LineString src) {
        return com.github.filosganga.geogson.model.LineString.of((Iterable)Iterables.transform((Iterable)JtsPointIterable.of(src), AbstractJtsCodec.fromJtsPointFn()));
    }

    protected static Point toJtsPoint(com.github.filosganga.geogson.model.Point src) {
        return new GeometryFactory().createPoint(new Coordinate(src.lon(), src.lat()));
    }

    protected static Function<Point, com.github.filosganga.geogson.model.Point> fromJtsPointFn() {
        return new Function<Point, com.github.filosganga.geogson.model.Point>(){

            public com.github.filosganga.geogson.model.Point apply(Point input) {
                return AbstractJtsCodec.fromJtsPoint(input);
            }
        };
    }

    protected static com.github.filosganga.geogson.model.Point fromJtsPoint(Point src) {
        return com.github.filosganga.geogson.model.Point.from((Coordinates)AbstractJtsCodec.fromJtsCoordinate(src.getCoordinate()));
    }

    protected static Function<Coordinates, Coordinate> toJtsCoordinateFn() {
        return ToJtsCoordinate.INSTANCE;
    }

    protected static Coordinates fromJtsCoordinate(Coordinate src) {
        return Coordinates.of((double)src.x, (double)src.y);
    }

    private static enum ToJtsCoordinate implements Function<Coordinates, Coordinate>
    {
        INSTANCE;


        public Coordinate apply(Coordinates input) {
            return new Coordinate(input.getLon(), input.getLat());
        }
    }
}

