/*
 * Decompiled with CFR 0.152.
 */
package com.github.gantsign.maven.plugin.ktlint.internal;

import com.github.gantsign.maven.plugin.ktlint.internal.AbstractLintSupport;
import com.github.gantsign.maven.plugin.ktlint.internal.Sources;
import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.RuleProvider;
import com.pinterest.ktlint.core.api.DefaultEditorConfigProperties;
import com.pinterest.ktlint.core.api.EditorConfigOverride;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010Jf\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u001726\u0010\u0019\u001a2\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u001a2\u0006\u0010!\u001a\u00020\"H\u0002J\t\u0010#\u001a\u00020 H\u0086\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/gantsign/maven/plugin/ktlint/internal/Format;", "Lcom/github/gantsign/maven/plugin/ktlint/internal/AbstractLintSupport;", "log", "Lorg/apache/maven/plugin/logging/Log;", "basedir", "Ljava/io/File;", "modulePackaging", "", "sources", "", "Lcom/github/gantsign/maven/plugin/ktlint/internal/Sources;", "charset", "Ljava/nio/charset/Charset;", "android", "", "enableExperimentalRules", "(Lorg/apache/maven/plugin/logging/Log;Ljava/io/File;Ljava/lang/String;Ljava/util/List;Ljava/nio/charset/Charset;ZZ)V", "formattedFileCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "formatFile", "fileName", "sourceText", "ruleProviders", "", "Lcom/pinterest/ktlint/core/RuleProvider;", "onError", "Lkotlin/Function2;", "Lcom/pinterest/ktlint/core/LintError;", "Lkotlin/ParameterName;", "name", "err", "corrected", "", "editorConfigOverride", "Lcom/pinterest/ktlint/core/api/EditorConfigOverride;", "invoke", "ktlint-maven-plugin"})
@SourceDebugExtension(value={"SMAP\nFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Format.kt\ncom/github/gantsign/maven/plugin/ktlint/internal/Format\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1#2:146\n37#3,2:147\n37#3,2:149\n11335#4:151\n11670#4,3:152\n1855#5,2:155\n*S KotlinDebug\n*F\n+ 1 Format.kt\ncom/github/gantsign/maven/plugin/ktlint/internal/Format\n*L\n77#1:147,2\n78#1:149,2\n88#1:151\n88#1:152,3\n90#1:155,2\n*E\n"})
public final class Format
extends AbstractLintSupport {
    @NotNull
    private final String modulePackaging;
    @NotNull
    private final List<Sources> sources;
    @NotNull
    private final Charset charset;
    @NotNull
    private final AtomicInteger formattedFileCount;

    public Format(@NotNull Log log, @NotNull File basedir, @NotNull String modulePackaging, @NotNull List<Sources> sources, @NotNull Charset charset, boolean android, boolean enableExperimentalRules) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)basedir, (String)"basedir");
        Intrinsics.checkNotNullParameter((Object)modulePackaging, (String)"modulePackaging");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        super(log, basedir, android, enableExperimentalRules);
        this.modulePackaging = modulePackaging;
        this.sources = sources;
        this.charset = charset;
        this.formattedFileCount = new AtomicInteger();
    }

    /*
     * WARNING - void declaration
     */
    public final void invoke() {
        Set checkedFiles = new LinkedHashSet();
        for (Sources sources : this.sources) {
            boolean isIncluded = sources.component1();
            Set<File> sourceRoots = sources.component2();
            String[] includes = sources.component3();
            Set<String> excludes = sources.component4();
            if (!isIncluded) {
                this.getLog().debug((CharSequence)("Source roots not included: " + sourceRoots));
                continue;
            }
            for (File sourceRoot : sourceRoots) {
                void $this$mapTo$iv$iv;
                Object object;
                block13: {
                    String[] $this$toTypedArray$iv;
                    block12: {
                        String[] stringArray;
                        if (!sourceRoot.exists()) {
                            String msg = "Source root doesn't exist: " + FilesKt.toRelativeString((File)sourceRoot, (File)this.getBasedir());
                            if (Intrinsics.areEqual((Object)this.modulePackaging, (Object)"pom")) {
                                this.getLog().debug((CharSequence)msg);
                                continue;
                            }
                            this.getLog().warn((CharSequence)msg);
                            continue;
                        }
                        if (!sourceRoot.isDirectory()) {
                            throw new MojoFailureException("Source root is not a directory: " + FilesKt.toRelativeString((File)sourceRoot, (File)this.getBasedir()));
                        }
                        String[] p0 = stringArray = includes;
                        boolean bl = false;
                        object = !p0.isEmpty() ? stringArray : null;
                        if (object == null) break block12;
                        $this$toTypedArray$iv = object;
                        boolean $i$f$toTypedArray = false;
                        String[] thisCollection$iv = $this$toTypedArray$iv;
                        object = thisCollection$iv.toArray(new String[0]);
                        if (object != null) break block13;
                    }
                    $this$toTypedArray$iv = new String[]{"**/*.kt"};
                    object = $this$toTypedArray$iv;
                }
                String[] includesArray = object;
                Collection $this$toTypedArray$iv = excludes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] excludesArray = thisCollection$iv.toArray(new String[0]);
                DirectoryScanner $this$invoke_u24lambda_u240 = $i$f$toTypedArray = new DirectoryScanner();
                boolean bl = false;
                $this$invoke_u24lambda_u240.setIncludes(Arrays.copyOf(includesArray, includesArray.length));
                $this$invoke_u24lambda_u240.setExcludes(Arrays.copyOf(excludesArray, excludesArray.length));
                $this$invoke_u24lambda_u240.setBasedir(sourceRoot);
                $this$invoke_u24lambda_u240.setCaseSensitive(true);
                DirectoryScanner ds = $i$f$toTypedArray;
                ds.scan();
                String[] stringArray = ds.getIncludedFiles();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"ds.includedFiles");
                Object[] $this$map$iv = stringArray;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(new File(sourceRoot, (String)it));
                }
                List sourceFiles = (List)destination$iv$iv;
                Iterable $this$forEach$iv = sourceFiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file = (File)element$iv;
                    boolean bl3 = false;
                    File file2 = file.getCanonicalFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file.canonicalFile");
                    if (!checkedFiles.add(file2)) continue;
                    String absolutePath = file.getAbsolutePath();
                    String baseRelativePath = FilesKt.toRelativeString((File)file, (File)this.getBasedir());
                    this.getLog().debug((CharSequence)("checking format: " + baseRelativePath));
                    EditorConfigOverride editorConfigOverride = EditorConfigOverride.Companion.getEmptyEditorConfigOverride();
                    if (this.getAndroid()) {
                        Pair[] bl2 = new Pair[]{TuplesKt.to((Object)DefaultEditorConfigProperties.INSTANCE.getCodeStyleSetProperty(), (Object)this.getAndroid())};
                        EditorConfigOverride.Companion.plus(editorConfigOverride, bl2);
                    }
                    String sourceText = FilesKt.readText((File)file, (Charset)this.charset);
                    Intrinsics.checkNotNullExpressionValue((Object)absolutePath, (String)"absolutePath");
                    String formattedText2 = this.formatFile(absolutePath, sourceText, this.getRuleProviders(), (Function2<? super LintError, ? super Boolean, Unit>)((Function2)new Function2<LintError, Boolean, Unit>(baseRelativePath, this){
                        final /* synthetic */ String $baseRelativePath;
                        final /* synthetic */ Format this$0;
                        {
                            this.$baseRelativePath = $baseRelativePath;
                            this.this$0 = $receiver;
                            super(2);
                        }

                        public final void invoke(@NotNull LintError lintError, boolean corrected) {
                            Intrinsics.checkNotNullParameter((Object)lintError, (String)"<name for destructuring parameter 0>");
                            int line = lintError.component1();
                            int col = lintError.component2();
                            String detail = lintError.component4();
                            String lintError2 = this.$baseRelativePath + ':' + line + ':' + col + ": " + detail;
                            this.this$0.getLog().debug((CharSequence)("Format " + (corrected ? "fixed" : "could not fix") + " > " + lintError2));
                        }
                    }), editorConfigOverride);
                    if (formattedText2 == sourceText) continue;
                    this.getLog().debug((CharSequence)("Format fixed > " + baseRelativePath));
                    FilesKt.writeText((File)file, (String)formattedText2, (Charset)this.charset);
                    this.formattedFileCount.incrementAndGet();
                }
            }
        }
        this.getLog().info((CharSequence)(this.formattedFileCount.get() + " file(s) formatted."));
    }

    private final String formatFile(String fileName, String sourceText, Set<RuleProvider> ruleProviders2, Function2<? super LintError, ? super Boolean, Unit> onError, EditorConfigOverride editorConfigOverride) {
        boolean bl = !StringsKt.endsWith((String)fileName, (String)".kt", (boolean)true);
        return KtLint.INSTANCE.format(new KtLint.ExperimentalParams(fileName, sourceText, ruleProviders2, null, onError, bl, false, null, editorConfigOverride, false, 712, null));
    }
}

