/*
 * Decompiled with CFR 0.152.
 */
package caliban.interop.tapir;

import caliban.GraphQLInterpreter;
import caliban.GraphQLWSClose;
import caliban.GraphQLWSInput;
import caliban.GraphQLWSInput$;
import caliban.GraphQLWSOutput;
import caliban.GraphQLWSOutput$;
import caliban.interop.tapir.IsTapirSchema$;
import caliban.interop.tapir.MaxCharBufSizeJsonJsoniter$;
import caliban.interop.tapir.TapirAdapter;
import caliban.interop.tapir.TapirAdapter$;
import caliban.interop.tapir.WebSocketInterpreter;
import caliban.ws.WebSocketHooks;
import caliban.ws.WebSocketHooks$;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.capabilities.package;
import sttp.capabilities.zio.ZioStreams;
import sttp.capabilities.zio.ZioStreams$;
import sttp.tapir.Codec;
import sttp.tapir.Codec$;
import sttp.tapir.CodecFormat;
import sttp.tapir.DecodeResult;
import sttp.tapir.Endpoint;
import sttp.tapir.EndpointErrorOutputsOps;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointInput;
import sttp.tapir.EndpointInputsOps;
import sttp.tapir.EndpointOutput;
import sttp.tapir.EndpointOutputsOps;
import sttp.tapir.Schema;
import sttp.tapir.Schema$;
import sttp.tapir.model.ServerRequest;
import sttp.tapir.model.UnsupportedWebSocketFrameException;
import sttp.tapir.package$;
import sttp.tapir.typelevel.ParamConcat$;
import sttp.tapir.typelevel.TupleArity$;
import sttp.tapir.typelevel.TupleOps;
import sttp.ws.WebSocketFrame;
import sttp.ws.WebSocketFrame$;
import zio.stream.ZStream;

public final class WebSocketInterpreter$ {
    public static final WebSocketInterpreter$ MODULE$ = new WebSocketInterpreter$();

    public <R, E> WebSocketInterpreter<R, E> apply(GraphQLInterpreter<R, E> interpreter, Option<Duration> keepAliveTime, WebSocketHooks<R, E> webSocketHooks) {
        return new WebSocketInterpreter.Base<R, E>(interpreter, keepAliveTime, webSocketHooks);
    }

    public <R, E> Option<Duration> apply$default$2() {
        return None$.MODULE$;
    }

    public <R, E> WebSocketHooks<R, E> apply$default$3() {
        return WebSocketHooks$.MODULE$.empty();
    }

    private <A, CF extends CodecFormat> Codec<WebSocketFrame, Either<GraphQLWSClose, A>, CF> textOrCloseWebSocketFrameEither(Codec<String, A, CF> stringCodec) {
        return Codec$.MODULE$.id(stringCodec.format(), Schema$.MODULE$.string()).mapDecode((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof WebSocketFrame.Text) {
                String s = ((WebSocketFrame.Text)x0$1).payload();
                return stringCodec.decode((Object)s).map((Function1 & Serializable)x$4 -> new Right(x$4));
            }
            if (x0$1 instanceof WebSocketFrame.Close) {
                WebSocketFrame.Close close = (WebSocketFrame.Close)x0$1;
                int code = close.statusCode();
                String reason = close.reasonText();
                return new DecodeResult.Value((Object)new Left((Object)new GraphQLWSClose(code, reason)));
            }
            return new DecodeResult.Error(x0$1.toString(), (Throwable)new UnsupportedWebSocketFrameException(x0$1));
        }, (Function1 & Serializable)x0$2 -> {
            if (x0$2 instanceof Left) {
                GraphQLWSClose value = (GraphQLWSClose)((Left)x0$2).value();
                return new WebSocketFrame.Close(value.code(), value.reason());
            }
            if (x0$2 instanceof Right) {
                Object value = ((Right)x0$2).value();
                return WebSocketFrame$.MODULE$.text((String)stringCodec.encode(value));
            }
            throw new MatchError(x0$2);
        });
    }

    public Endpoint<BoxedUnit, Tuple2<ServerRequest, String>, TapirAdapter.TapirResponse, Tuple2<String, Function1<ZStream<Object, Throwable, GraphQLWSInput>, ZStream<Object, Throwable, Either<GraphQLWSClose, GraphQLWSOutput>>>>, ZioStreams> makeWebSocketEndpoint() {
        EndpointIO.Header protocolHeader = package$.MODULE$.header("sec-websocket-protocol", Codec$.MODULE$.listHead(Codec$.MODULE$.string()));
        return (Endpoint)((EndpointErrorOutputsOps)((EndpointOutputsOps)((EndpointOutputsOps)((EndpointInputsOps)package$.MODULE$.endpoint().in((EndpointInput)package$.MODULE$.extractFromRequest((Function1 & Serializable)x -> (ServerRequest)Predef$.MODULE$.identity(x)), ParamConcat$.MODULE$.concatUnitLeft(TupleArity$.MODULE$.tupleArity1()))).in((EndpointInput)protocolHeader, ParamConcat$.MODULE$.concatSingleAndSingle(TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append1())))))).out((EndpointOutput)protocolHeader, ParamConcat$.MODULE$.concatUnitLeft(TupleArity$.MODULE$.tupleArity1()))).out(package$.MODULE$.webSocketBody().apply((package.Streams)ZioStreams$.MODULE$, Codec$.MODULE$.textWebSocketFrame(MaxCharBufSizeJsonJsoniter$.MODULE$.jsoniterCodec(GraphQLWSInput$.MODULE$.jsoniterCodec(), (Schema)GraphQLWSInput$.MODULE$.tapirSchema(IsTapirSchema$.MODULE$.isTapirSchema()))), this.textOrCloseWebSocketFrameEither(MaxCharBufSizeJsonJsoniter$.MODULE$.jsoniterCodec(GraphQLWSOutput$.MODULE$.jsoniterCodec(), (Schema)GraphQLWSOutput$.MODULE$.tapirSchema(IsTapirSchema$.MODULE$.isTapirSchema())))), ParamConcat$.MODULE$.concatSingleAndSingle(TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append1())))))).errorOut(TapirAdapter$.MODULE$.errorBody(), ParamConcat$.MODULE$.concatUnitLeft(TupleArity$.MODULE$.tupleArity1()));
    }

    private WebSocketInterpreter$() {
    }
}

