/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.http.client.entity;

import com.github.igorsuhorukov.apache.http.Header;
import com.github.igorsuhorukov.apache.http.HttpEntity;
import com.github.igorsuhorukov.apache.http.entity.HttpEntityWrapper;
import com.github.igorsuhorukov.apache.http.message.BasicHeader;
import com.github.igorsuhorukov.apache.http.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class GzipCompressingEntity
extends HttpEntityWrapper {
    private static final String GZIP_CODEC = "gzip";

    public GzipCompressingEntity(HttpEntity entity) {
        super(entity);
    }

    public Header getContentEncoding() {
        return new BasicHeader("Content-Encoding", GZIP_CODEC);
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean isChunked() {
        return true;
    }

    public InputStream getContent() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull(outstream, "Output stream");
        GZIPOutputStream gzip = new GZIPOutputStream(outstream);
        this.wrappedEntity.writeTo(gzip);
        gzip.close();
    }
}

