/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.http.client.protocol;

import com.github.igorsuhorukov.apache.http.HttpEntity;
import com.github.igorsuhorukov.apache.http.HttpEntityEnclosingRequest;
import com.github.igorsuhorukov.apache.http.HttpException;
import com.github.igorsuhorukov.apache.http.HttpRequest;
import com.github.igorsuhorukov.apache.http.HttpRequestInterceptor;
import com.github.igorsuhorukov.apache.http.HttpVersion;
import com.github.igorsuhorukov.apache.http.ProtocolVersion;
import com.github.igorsuhorukov.apache.http.annotation.Immutable;
import com.github.igorsuhorukov.apache.http.client.config.RequestConfig;
import com.github.igorsuhorukov.apache.http.client.protocol.HttpClientContext;
import com.github.igorsuhorukov.apache.http.protocol.HttpContext;
import com.github.igorsuhorukov.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

