/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.http.impl.client;

import com.github.igorsuhorukov.apache.http.HttpEntity;
import com.github.igorsuhorukov.apache.http.HttpResponse;
import com.github.igorsuhorukov.apache.http.annotation.NotThreadSafe;
import com.github.igorsuhorukov.apache.http.client.methods.CloseableHttpResponse;
import com.github.igorsuhorukov.apache.http.util.EntityUtils;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

@NotThreadSafe
class CloseableHttpResponseProxy
implements InvocationHandler {
    private final HttpResponse original;

    CloseableHttpResponseProxy(HttpResponse original) {
        this.original = original;
    }

    public void close() throws IOException {
        HttpEntity entity = this.original.getEntity();
        EntityUtils.consume(entity);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String mname = method.getName();
        if (mname.equals("close")) {
            this.close();
            return null;
        }
        try {
            return method.invoke((Object)this.original, args);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                throw cause;
            }
            throw ex;
        }
    }

    public static CloseableHttpResponse newProxy(HttpResponse original) {
        return (CloseableHttpResponse)Proxy.newProxyInstance(CloseableHttpResponseProxy.class.getClassLoader(), new Class[]{CloseableHttpResponse.class}, (InvocationHandler)new CloseableHttpResponseProxy(original));
    }
}

