/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.http.impl.cookie;

import com.github.igorsuhorukov.apache.http.annotation.Immutable;
import com.github.igorsuhorukov.apache.http.cookie.Cookie;
import com.github.igorsuhorukov.apache.http.cookie.CookieOrigin;
import com.github.igorsuhorukov.apache.http.cookie.MalformedCookieException;
import com.github.igorsuhorukov.apache.http.cookie.SetCookie;
import com.github.igorsuhorukov.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.github.igorsuhorukov.apache.http.util.Args;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }
}

