/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.http.message;

import com.github.igorsuhorukov.apache.http.Header;
import com.github.igorsuhorukov.apache.http.HeaderIterator;
import com.github.igorsuhorukov.apache.http.HttpMessage;
import com.github.igorsuhorukov.apache.http.annotation.NotThreadSafe;
import com.github.igorsuhorukov.apache.http.message.BasicHeader;
import com.github.igorsuhorukov.apache.http.message.HeaderGroup;
import com.github.igorsuhorukov.apache.http.params.BasicHttpParams;
import com.github.igorsuhorukov.apache.http.params.HttpParams;
import com.github.igorsuhorukov.apache.http.util.Args;

@NotThreadSafe
public abstract class AbstractHttpMessage
implements HttpMessage {
    protected HeaderGroup headergroup = new HeaderGroup();
    @Deprecated
    protected HttpParams params;

    @Deprecated
    protected AbstractHttpMessage(HttpParams params) {
        this.params = params;
    }

    protected AbstractHttpMessage() {
        this(null);
    }

    public boolean containsHeader(String name) {
        return this.headergroup.containsHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.headergroup.getHeaders(name);
    }

    public Header getFirstHeader(String name) {
        return this.headergroup.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.headergroup.getLastHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.headergroup.getAllHeaders();
    }

    public void addHeader(Header header) {
        this.headergroup.addHeader(header);
    }

    public void addHeader(String name, String value) {
        Args.notNull(name, "Header name");
        this.headergroup.addHeader(new BasicHeader(name, value));
    }

    public void setHeader(Header header) {
        this.headergroup.updateHeader(header);
    }

    public void setHeader(String name, String value) {
        Args.notNull(name, "Header name");
        this.headergroup.updateHeader(new BasicHeader(name, value));
    }

    public void setHeaders(Header[] headers) {
        this.headergroup.setHeaders(headers);
    }

    public void removeHeader(Header header) {
        this.headergroup.removeHeader(header);
    }

    public void removeHeaders(String name) {
        if (name == null) {
            return;
        }
        HeaderIterator i = this.headergroup.iterator();
        while (i.hasNext()) {
            Header header = i.nextHeader();
            if (!name.equalsIgnoreCase(header.getName())) continue;
            i.remove();
        }
    }

    public HeaderIterator headerIterator() {
        return this.headergroup.iterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.headergroup.iterator(name);
    }

    @Deprecated
    public HttpParams getParams() {
        if (this.params == null) {
            this.params = new BasicHttpParams();
        }
        return this.params;
    }

    @Deprecated
    public void setParams(HttpParams params) {
        this.params = Args.notNull(params, "HTTP parameters");
    }
}

