/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.http.protocol;

import com.github.igorsuhorukov.apache.http.HttpException;
import com.github.igorsuhorukov.apache.http.HttpRequest;
import com.github.igorsuhorukov.apache.http.HttpRequestInterceptor;
import com.github.igorsuhorukov.apache.http.annotation.Immutable;
import com.github.igorsuhorukov.apache.http.protocol.HttpContext;
import com.github.igorsuhorukov.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestConnControl
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

