/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.http.protocol;

import com.github.igorsuhorukov.apache.http.HttpEntityEnclosingRequest;
import com.github.igorsuhorukov.apache.http.HttpException;
import com.github.igorsuhorukov.apache.http.HttpRequest;
import com.github.igorsuhorukov.apache.http.HttpRequestInterceptor;
import com.github.igorsuhorukov.apache.http.annotation.ThreadSafe;
import com.github.igorsuhorukov.apache.http.protocol.HttpContext;
import com.github.igorsuhorukov.apache.http.protocol.HttpDateGenerator;
import com.github.igorsuhorukov.apache.http.util.Args;
import java.io.IOException;

@ThreadSafe
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

