/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.http.protocol;

import com.github.igorsuhorukov.apache.http.HttpException;
import com.github.igorsuhorukov.apache.http.HttpResponse;
import com.github.igorsuhorukov.apache.http.HttpResponseInterceptor;
import com.github.igorsuhorukov.apache.http.annotation.ThreadSafe;
import com.github.igorsuhorukov.apache.http.protocol.HttpContext;
import com.github.igorsuhorukov.apache.http.protocol.HttpDateGenerator;
import com.github.igorsuhorukov.apache.http.util.Args;
import java.io.IOException;

@ThreadSafe
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

