/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.maven.building;

import com.github.igorsuhorukov.apache.commons.lang3.Validate;
import com.github.igorsuhorukov.apache.maven.building.Source;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileSource
implements Source {
    private final File file;

    public FileSource(File file) {
        this.file = Validate.notNull(file, "file cannot be null", new Object[0]).getAbsoluteFile();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public String getLocation() {
        return this.file.getPath();
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.getLocation();
    }
}

