/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.maven.model.building;

import com.github.igorsuhorukov.apache.maven.model.Model;
import com.github.igorsuhorukov.apache.maven.model.building.DefaultModelBuilder;
import com.github.igorsuhorukov.apache.maven.model.building.DefaultModelProcessor;
import com.github.igorsuhorukov.apache.maven.model.building.ModelBuildingRequest;
import com.github.igorsuhorukov.apache.maven.model.building.ModelProblemCollector;
import com.github.igorsuhorukov.apache.maven.model.building.ModelProcessor;
import com.github.igorsuhorukov.apache.maven.model.composition.DefaultDependencyManagementImporter;
import com.github.igorsuhorukov.apache.maven.model.composition.DependencyManagementImporter;
import com.github.igorsuhorukov.apache.maven.model.inheritance.DefaultInheritanceAssembler;
import com.github.igorsuhorukov.apache.maven.model.inheritance.InheritanceAssembler;
import com.github.igorsuhorukov.apache.maven.model.interpolation.ModelInterpolator;
import com.github.igorsuhorukov.apache.maven.model.interpolation.StringSearchModelInterpolator;
import com.github.igorsuhorukov.apache.maven.model.io.DefaultModelReader;
import com.github.igorsuhorukov.apache.maven.model.io.ModelReader;
import com.github.igorsuhorukov.apache.maven.model.locator.DefaultModelLocator;
import com.github.igorsuhorukov.apache.maven.model.locator.ModelLocator;
import com.github.igorsuhorukov.apache.maven.model.management.DefaultDependencyManagementInjector;
import com.github.igorsuhorukov.apache.maven.model.management.DefaultPluginManagementInjector;
import com.github.igorsuhorukov.apache.maven.model.management.DependencyManagementInjector;
import com.github.igorsuhorukov.apache.maven.model.management.PluginManagementInjector;
import com.github.igorsuhorukov.apache.maven.model.normalization.DefaultModelNormalizer;
import com.github.igorsuhorukov.apache.maven.model.normalization.ModelNormalizer;
import com.github.igorsuhorukov.apache.maven.model.path.DefaultModelPathTranslator;
import com.github.igorsuhorukov.apache.maven.model.path.DefaultModelUrlNormalizer;
import com.github.igorsuhorukov.apache.maven.model.path.DefaultPathTranslator;
import com.github.igorsuhorukov.apache.maven.model.path.DefaultUrlNormalizer;
import com.github.igorsuhorukov.apache.maven.model.path.ModelPathTranslator;
import com.github.igorsuhorukov.apache.maven.model.path.ModelUrlNormalizer;
import com.github.igorsuhorukov.apache.maven.model.path.PathTranslator;
import com.github.igorsuhorukov.apache.maven.model.path.UrlNormalizer;
import com.github.igorsuhorukov.apache.maven.model.plugin.DefaultPluginConfigurationExpander;
import com.github.igorsuhorukov.apache.maven.model.plugin.DefaultReportConfigurationExpander;
import com.github.igorsuhorukov.apache.maven.model.plugin.DefaultReportingConverter;
import com.github.igorsuhorukov.apache.maven.model.plugin.LifecycleBindingsInjector;
import com.github.igorsuhorukov.apache.maven.model.plugin.PluginConfigurationExpander;
import com.github.igorsuhorukov.apache.maven.model.plugin.ReportConfigurationExpander;
import com.github.igorsuhorukov.apache.maven.model.plugin.ReportingConverter;
import com.github.igorsuhorukov.apache.maven.model.profile.DefaultProfileInjector;
import com.github.igorsuhorukov.apache.maven.model.profile.DefaultProfileSelector;
import com.github.igorsuhorukov.apache.maven.model.profile.ProfileInjector;
import com.github.igorsuhorukov.apache.maven.model.profile.ProfileSelector;
import com.github.igorsuhorukov.apache.maven.model.profile.activation.FileProfileActivator;
import com.github.igorsuhorukov.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import com.github.igorsuhorukov.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import com.github.igorsuhorukov.apache.maven.model.profile.activation.ProfileActivator;
import com.github.igorsuhorukov.apache.maven.model.profile.activation.PropertyProfileActivator;
import com.github.igorsuhorukov.apache.maven.model.superpom.DefaultSuperPomProvider;
import com.github.igorsuhorukov.apache.maven.model.superpom.SuperPomProvider;
import com.github.igorsuhorukov.apache.maven.model.validation.DefaultModelValidator;
import com.github.igorsuhorukov.apache.maven.model.validation.ModelValidator;

public class DefaultModelBuilderFactory {
    protected ModelProcessor newModelProcessor() {
        DefaultModelProcessor processor = new DefaultModelProcessor();
        processor.setModelLocator(this.newModelLocator());
        processor.setModelReader(this.newModelReader());
        return processor;
    }

    protected ModelLocator newModelLocator() {
        return new DefaultModelLocator();
    }

    protected ModelReader newModelReader() {
        return new DefaultModelReader();
    }

    protected ProfileSelector newProfileSelector() {
        DefaultProfileSelector profileSelector = new DefaultProfileSelector();
        for (ProfileActivator activator : this.newProfileActivators()) {
            profileSelector.addProfileActivator(activator);
        }
        return profileSelector;
    }

    protected ProfileActivator[] newProfileActivators() {
        return new ProfileActivator[]{new JdkVersionProfileActivator(), new OperatingSystemProfileActivator(), new PropertyProfileActivator(), new FileProfileActivator().setPathTranslator(this.newPathTranslator())};
    }

    protected UrlNormalizer newUrlNormalizer() {
        return new DefaultUrlNormalizer();
    }

    protected PathTranslator newPathTranslator() {
        return new DefaultPathTranslator();
    }

    protected ModelInterpolator newModelInterpolator() {
        UrlNormalizer normalizer = this.newUrlNormalizer();
        PathTranslator pathTranslator = this.newPathTranslator();
        return new StringSearchModelInterpolator().setPathTranslator(pathTranslator).setUrlNormalizer(normalizer);
    }

    protected ModelValidator newModelValidator() {
        return new DefaultModelValidator();
    }

    protected ModelNormalizer newModelNormalizer() {
        return new DefaultModelNormalizer();
    }

    protected ModelPathTranslator newModelPathTranslator() {
        return new DefaultModelPathTranslator().setPathTranslator(this.newPathTranslator());
    }

    protected ModelUrlNormalizer newModelUrlNormalizer() {
        return new DefaultModelUrlNormalizer().setUrlNormalizer(this.newUrlNormalizer());
    }

    protected InheritanceAssembler newInheritanceAssembler() {
        return new DefaultInheritanceAssembler();
    }

    protected ProfileInjector newProfileInjector() {
        return new DefaultProfileInjector();
    }

    protected SuperPomProvider newSuperPomProvider() {
        return new DefaultSuperPomProvider().setModelProcessor(this.newModelProcessor());
    }

    protected DependencyManagementImporter newDependencyManagementImporter() {
        return new DefaultDependencyManagementImporter();
    }

    protected DependencyManagementInjector newDependencyManagementInjector() {
        return new DefaultDependencyManagementInjector();
    }

    protected LifecycleBindingsInjector newLifecycleBindingsInjector() {
        return new StubLifecycleBindingsInjector();
    }

    protected PluginManagementInjector newPluginManagementInjector() {
        return new DefaultPluginManagementInjector();
    }

    protected PluginConfigurationExpander newPluginConfigurationExpander() {
        return new DefaultPluginConfigurationExpander();
    }

    protected ReportConfigurationExpander newReportConfigurationExpander() {
        return new DefaultReportConfigurationExpander();
    }

    protected ReportingConverter newReportingConverter() {
        return new DefaultReportingConverter();
    }

    public DefaultModelBuilder newInstance() {
        DefaultModelBuilder modelBuilder = new DefaultModelBuilder();
        modelBuilder.setModelProcessor(this.newModelProcessor());
        modelBuilder.setModelValidator(this.newModelValidator());
        modelBuilder.setModelNormalizer(this.newModelNormalizer());
        modelBuilder.setModelPathTranslator(this.newModelPathTranslator());
        modelBuilder.setModelUrlNormalizer(this.newModelUrlNormalizer());
        modelBuilder.setModelInterpolator(this.newModelInterpolator());
        modelBuilder.setInheritanceAssembler(this.newInheritanceAssembler());
        modelBuilder.setProfileInjector(this.newProfileInjector());
        modelBuilder.setProfileSelector(this.newProfileSelector());
        modelBuilder.setSuperPomProvider(this.newSuperPomProvider());
        modelBuilder.setDependencyManagementImporter(this.newDependencyManagementImporter());
        modelBuilder.setDependencyManagementInjector(this.newDependencyManagementInjector());
        modelBuilder.setLifecycleBindingsInjector(this.newLifecycleBindingsInjector());
        modelBuilder.setPluginManagementInjector(this.newPluginManagementInjector());
        modelBuilder.setPluginConfigurationExpander(this.newPluginConfigurationExpander());
        modelBuilder.setReportConfigurationExpander(this.newReportConfigurationExpander());
        modelBuilder.setReportingConverter(this.newReportingConverter());
        return modelBuilder;
    }

    private static class StubLifecycleBindingsInjector
    implements LifecycleBindingsInjector {
        private StubLifecycleBindingsInjector() {
        }

        @Override
        public void injectLifecycleBindings(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        }
    }
}

