/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.maven.model.interpolation;

import com.github.igorsuhorukov.apache.maven.model.path.PathTranslator;
import com.github.igorsuhorukov.codehaus.plexus.interpolation.InterpolationPostProcessor;
import com.github.igorsuhorukov.codehaus.plexus.interpolation.util.ValueSourceUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;

class PathTranslatingPostProcessor
implements InterpolationPostProcessor {
    private final Collection<String> unprefixedPathKeys;
    private final File projectDir;
    private final PathTranslator pathTranslator;
    private final List<String> expressionPrefixes;

    public PathTranslatingPostProcessor(List<String> expressionPrefixes, Collection<String> unprefixedPathKeys, File projectDir, PathTranslator pathTranslator) {
        this.expressionPrefixes = expressionPrefixes;
        this.unprefixedPathKeys = unprefixedPathKeys;
        this.projectDir = projectDir;
        this.pathTranslator = pathTranslator;
    }

    @Override
    public Object execute(String expression, Object value) {
        if (value != null && this.unprefixedPathKeys.contains(expression = ValueSourceUtils.trimPrefix(expression, this.expressionPrefixes, true))) {
            return this.pathTranslator.alignToBaseDirectory(String.valueOf(value), this.projectDir);
        }
        return null;
    }
}

