/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.maven.model.io;

import com.github.igorsuhorukov.apache.commons.lang3.Validate;
import com.github.igorsuhorukov.apache.maven.model.InputSource;
import com.github.igorsuhorukov.apache.maven.model.Model;
import com.github.igorsuhorukov.apache.maven.model.io.ModelParseException;
import com.github.igorsuhorukov.apache.maven.model.io.ModelReader;
import com.github.igorsuhorukov.apache.maven.model.io.xpp3.MavenXpp3Reader;
import com.github.igorsuhorukov.apache.maven.model.io.xpp3.MavenXpp3ReaderEx;
import com.github.igorsuhorukov.codehaus.plexus.component.annotations.Component;
import com.github.igorsuhorukov.codehaus.plexus.util.IOUtil;
import com.github.igorsuhorukov.codehaus.plexus.util.ReaderFactory;
import com.github.igorsuhorukov.codehaus.plexus.util.xml.pull.XmlPullParserException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;

@Component(role=ModelReader.class)
public class DefaultModelReader
implements ModelReader {
    @Override
    public Model read(File input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        Model model = this.read(new FileInputStream(input), options);
        model.setPomFile(input);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model read(Reader input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        try {
            Model model = this.read(input, this.isStrict(options), this.getSource(options));
            return model;
        }
        finally {
            IOUtil.close(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        try {
            Model model = this.read(ReaderFactory.newXmlReader(input), this.isStrict(options), this.getSource(options));
            return model;
        }
        finally {
            IOUtil.close(input);
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("com.github.igorsuhorukov.apache.maven.model.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }

    private InputSource getSource(Map<String, ?> options) {
        Object value = options != null ? options.get("com.github.igorsuhorukov.apache.maven.model.io.inputSource") : null;
        return value;
    }

    private Model read(Reader reader, boolean strict, InputSource source) throws IOException {
        try {
            if (source != null) {
                return new MavenXpp3ReaderEx().read(reader, strict, source);
            }
            return new MavenXpp3Reader().read(reader, strict);
        }
        catch (XmlPullParserException e) {
            throw new ModelParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
    }
}

