/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.maven.repository.internal;

import com.github.igorsuhorukov.apache.maven.model.DependencyManagement;
import com.github.igorsuhorukov.apache.maven.model.DistributionManagement;
import com.github.igorsuhorukov.apache.maven.model.Exclusion;
import com.github.igorsuhorukov.apache.maven.model.License;
import com.github.igorsuhorukov.apache.maven.model.Model;
import com.github.igorsuhorukov.apache.maven.model.Prerequisites;
import com.github.igorsuhorukov.apache.maven.model.Repository;
import com.github.igorsuhorukov.apache.maven.repository.internal.ArtifactDescriptorUtils;
import com.github.igorsuhorukov.eclipse.aether.RepositorySystemSession;
import com.github.igorsuhorukov.eclipse.aether.artifact.Artifact;
import com.github.igorsuhorukov.eclipse.aether.artifact.ArtifactType;
import com.github.igorsuhorukov.eclipse.aether.artifact.ArtifactTypeRegistry;
import com.github.igorsuhorukov.eclipse.aether.artifact.DefaultArtifact;
import com.github.igorsuhorukov.eclipse.aether.artifact.DefaultArtifactType;
import com.github.igorsuhorukov.eclipse.aether.graph.Dependency;
import com.github.igorsuhorukov.eclipse.aether.resolution.ArtifactDescriptorResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ArtifactDescriptorReaderDelegate {
    public void populateResult(RepositorySystemSession session, ArtifactDescriptorResult result, Model model) {
        ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
        for (Repository r : model.getRepositories()) {
            result.addRepository(ArtifactDescriptorUtils.toRemoteRepository(r));
        }
        for (com.github.igorsuhorukov.apache.maven.model.Dependency dependency : model.getDependencies()) {
            result.addDependency(this.convert(dependency, stereotypes));
        }
        DependencyManagement mngt = model.getDependencyManagement();
        if (mngt != null) {
            for (com.github.igorsuhorukov.apache.maven.model.Dependency dependency : mngt.getDependencies()) {
                result.addManagedDependency(this.convert(dependency, stereotypes));
            }
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        Prerequisites prerequisites = model.getPrerequisites();
        if (prerequisites != null) {
            properties.put("prerequisites.maven", prerequisites.getMaven());
        }
        List<License> licenses = model.getLicenses();
        properties.put("license.count", licenses.size());
        for (int i = 0; i < licenses.size(); ++i) {
            License license = licenses.get(i);
            properties.put("license." + i + ".name", license.getName());
            properties.put("license." + i + ".url", license.getUrl());
            properties.put("license." + i + ".comments", license.getComments());
            properties.put("license." + i + ".distribution", license.getDistribution());
        }
        result.setProperties(properties);
        this.setArtifactProperties(result, model);
    }

    private Dependency convert(com.github.igorsuhorukov.apache.maven.model.Dependency dependency, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<com.github.igorsuhorukov.eclipse.aether.graph.Exclusion> exclusions = new ArrayList<com.github.igorsuhorukov.eclipse.aether.graph.Exclusion>(dependency.getExclusions().size());
        for (Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(this.convert(exclusion));
        }
        Dependency result = new Dependency((Artifact)artifact, dependency.getScope(), dependency.isOptional(), exclusions);
        return result;
    }

    private com.github.igorsuhorukov.eclipse.aether.graph.Exclusion convert(Exclusion exclusion) {
        return new com.github.igorsuhorukov.eclipse.aether.graph.Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    private void setArtifactProperties(ArtifactDescriptorResult result, Model model) {
        String downloadUrl = null;
        DistributionManagement distMngt = model.getDistributionManagement();
        if (distMngt != null) {
            downloadUrl = distMngt.getDownloadUrl();
        }
        if (downloadUrl != null && downloadUrl.length() > 0) {
            Artifact artifact = result.getArtifact();
            HashMap<String, String> props = new HashMap<String, String>(artifact.getProperties());
            props.put("downloadUrl", downloadUrl);
            result.setArtifact(artifact.setProperties(props));
        }
    }
}

