/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.maven.repository.internal;

import com.github.igorsuhorukov.apache.maven.model.Repository;
import com.github.igorsuhorukov.apache.maven.model.RepositoryPolicy;
import com.github.igorsuhorukov.eclipse.aether.artifact.Artifact;
import com.github.igorsuhorukov.eclipse.aether.artifact.DefaultArtifact;
import com.github.igorsuhorukov.eclipse.aether.repository.RemoteRepository;

public class ArtifactDescriptorUtils {
    public static Artifact toPomArtifact(Artifact artifact) {
        Artifact pomArtifact = artifact;
        if (pomArtifact.getClassifier().length() > 0 || !"pom".equals(pomArtifact.getExtension())) {
            pomArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "pom", artifact.getVersion());
        }
        return pomArtifact;
    }

    public static RemoteRepository toRemoteRepository(Repository repository) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl());
        builder.setSnapshotPolicy(ArtifactDescriptorUtils.toRepositoryPolicy(repository.getSnapshots()));
        builder.setReleasePolicy(ArtifactDescriptorUtils.toRepositoryPolicy(repository.getReleases()));
        return builder.build();
    }

    public static com.github.igorsuhorukov.eclipse.aether.repository.RepositoryPolicy toRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new com.github.igorsuhorukov.eclipse.aether.repository.RepositoryPolicy(enabled, updates, checksums);
    }
}

