/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.maven.repository.internal;

import com.github.igorsuhorukov.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import com.github.igorsuhorukov.apache.maven.repository.internal.DefaultVersionRangeResolver;
import com.github.igorsuhorukov.apache.maven.repository.internal.DefaultVersionResolver;
import com.github.igorsuhorukov.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import com.github.igorsuhorukov.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import com.github.igorsuhorukov.eclipse.aether.DefaultRepositorySystemSession;
import com.github.igorsuhorukov.eclipse.aether.artifact.DefaultArtifactType;
import com.github.igorsuhorukov.eclipse.aether.impl.ArtifactDescriptorReader;
import com.github.igorsuhorukov.eclipse.aether.impl.DefaultServiceLocator;
import com.github.igorsuhorukov.eclipse.aether.impl.MetadataGeneratorFactory;
import com.github.igorsuhorukov.eclipse.aether.impl.VersionRangeResolver;
import com.github.igorsuhorukov.eclipse.aether.impl.VersionResolver;
import com.github.igorsuhorukov.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import com.github.igorsuhorukov.eclipse.aether.util.graph.manager.ClassicDependencyManager;
import com.github.igorsuhorukov.eclipse.aether.util.graph.selector.AndDependencySelector;
import com.github.igorsuhorukov.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import com.github.igorsuhorukov.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import com.github.igorsuhorukov.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import com.github.igorsuhorukov.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import com.github.igorsuhorukov.eclipse.aether.util.graph.transformer.ConflictResolver;
import com.github.igorsuhorukov.eclipse.aether.util.graph.transformer.JavaDependencyContextRefiner;
import com.github.igorsuhorukov.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import com.github.igorsuhorukov.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import com.github.igorsuhorukov.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import com.github.igorsuhorukov.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import com.github.igorsuhorukov.eclipse.aether.util.graph.traverser.FatArtifactTraverser;
import com.github.igorsuhorukov.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import java.util.Properties;

public final class MavenRepositorySystemUtils {
    private MavenRepositorySystemUtils() {
    }

    public static DefaultServiceLocator newServiceLocator() {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.addService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        locator.addService(VersionResolver.class, DefaultVersionResolver.class);
        locator.addService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        locator.addService(MetadataGeneratorFactory.class, SnapshotMetadataGeneratorFactory.class);
        locator.addService(MetadataGeneratorFactory.class, VersionsMetadataGeneratorFactory.class);
        return locator;
    }

    public static DefaultRepositorySystemSession newSession() {
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession();
        FatArtifactTraverser depTraverser = new FatArtifactTraverser();
        session.setDependencyTraverser(depTraverser);
        ClassicDependencyManager depManager = new ClassicDependencyManager();
        session.setDependencyManager(depManager);
        AndDependencySelector depFilter = new AndDependencySelector(new ScopeDependencySelector("test", "provided"), new OptionalDependencySelector(), new ExclusionDependencySelector());
        session.setDependencySelector(depFilter);
        ConflictResolver transformer = new ConflictResolver(new NearestVersionSelector(), new JavaScopeSelector(), new SimpleOptionalitySelector(), new JavaScopeDeriver());
        new ChainedDependencyGraphTransformer(transformer, new JavaDependencyContextRefiner());
        session.setDependencyGraphTransformer(transformer);
        DefaultArtifactTypeRegistry stereotypes = new DefaultArtifactTypeRegistry();
        stereotypes.add(new DefaultArtifactType("pom"));
        stereotypes.add(new DefaultArtifactType("maven-plugin", "jar", "", "java"));
        stereotypes.add(new DefaultArtifactType("jar", "jar", "", "java"));
        stereotypes.add(new DefaultArtifactType("ejb", "jar", "", "java"));
        stereotypes.add(new DefaultArtifactType("ejb-client", "jar", "client", "java"));
        stereotypes.add(new DefaultArtifactType("test-jar", "jar", "tests", "java"));
        stereotypes.add(new DefaultArtifactType("javadoc", "jar", "javadoc", "java"));
        stereotypes.add(new DefaultArtifactType("java-source", "jar", "sources", "java", false, false));
        stereotypes.add(new DefaultArtifactType("war", "war", "", "java", false, true));
        stereotypes.add(new DefaultArtifactType("ear", "ear", "", "java", false, true));
        stereotypes.add(new DefaultArtifactType("rar", "rar", "", "java", false, true));
        stereotypes.add(new DefaultArtifactType("par", "par", "", "java", false, true));
        session.setArtifactTypeRegistry(stereotypes);
        session.setArtifactDescriptorPolicy(new SimpleArtifactDescriptorPolicy(true, true));
        Properties sysProps = new Properties();
        for (String key : System.getProperties().stringPropertyNames()) {
            sysProps.put(key, System.getProperty(key));
        }
        session.setSystemProperties(sysProps);
        session.setConfigProperties(sysProps);
        return session;
    }
}

