/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.eclipse.aether.internal.impl;

import com.github.igorsuhorukov.eclipse.aether.RepositorySystemSession;
import com.github.igorsuhorukov.eclipse.aether.internal.impl.SimpleLocalRepositoryManager;
import com.github.igorsuhorukov.eclipse.aether.repository.LocalRepository;
import com.github.igorsuhorukov.eclipse.aether.repository.LocalRepositoryManager;
import com.github.igorsuhorukov.eclipse.aether.repository.NoLocalRepositoryManagerException;
import com.github.igorsuhorukov.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import com.github.igorsuhorukov.eclipse.aether.spi.locator.Service;
import com.github.igorsuhorukov.eclipse.aether.spi.locator.ServiceLocator;
import com.github.igorsuhorukov.eclipse.aether.spi.log.Logger;
import com.github.igorsuhorukov.eclipse.aether.spi.log.LoggerFactory;
import com.github.igorsuhorukov.eclipse.aether.spi.log.NullLoggerFactory;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="simple")
public class SimpleLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private float priority;

    public SimpleLocalRepositoryManagerFactory() {
    }

    @Inject
    SimpleLocalRepositoryManagerFactory(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public LocalRepositoryManager newInstance(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        if ("".equals(repository.getContentType()) || "simple".equals(repository.getContentType())) {
            return new SimpleLocalRepositoryManager(repository.getBasedir()).setLogger(this.logger);
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
    }

    public SimpleLocalRepositoryManagerFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, SimpleLocalRepositoryManager.class);
        return this;
    }

    public float getPriority() {
        return this.priority;
    }

    public SimpleLocalRepositoryManagerFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }
}

