/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.eclipse.aether.repository;

import com.github.igorsuhorukov.eclipse.aether.repository.LocalArtifactRequest;
import com.github.igorsuhorukov.eclipse.aether.repository.RemoteRepository;
import java.io.File;

public final class LocalArtifactResult {
    private final LocalArtifactRequest request;
    private File file;
    private boolean available;
    private RemoteRepository repository;

    public LocalArtifactResult(LocalArtifactRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("local artifact request has not been specified");
        }
        this.request = request;
    }

    public LocalArtifactRequest getRequest() {
        return this.request;
    }

    public File getFile() {
        return this.file;
    }

    public LocalArtifactResult setFile(File file) {
        this.file = file;
        return this;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public LocalArtifactResult setAvailable(boolean available) {
        this.available = available;
        return this;
    }

    public RemoteRepository getRepository() {
        return this.repository;
    }

    public LocalArtifactResult setRepository(RemoteRepository repository) {
        this.repository = repository;
        return this;
    }

    public String toString() {
        return this.getFile() + " (" + (this.isAvailable() ? "available" : "unavailable") + ")";
    }
}

