/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.eclipse.aether.transport.http;

import com.github.igorsuhorukov.eclipse.aether.RepositorySystemSession;
import com.github.igorsuhorukov.eclipse.aether.repository.RemoteRepository;
import com.github.igorsuhorukov.eclipse.aether.spi.connector.transport.Transporter;
import com.github.igorsuhorukov.eclipse.aether.spi.connector.transport.TransporterFactory;
import com.github.igorsuhorukov.eclipse.aether.spi.locator.Service;
import com.github.igorsuhorukov.eclipse.aether.spi.locator.ServiceLocator;
import com.github.igorsuhorukov.eclipse.aether.spi.log.Logger;
import com.github.igorsuhorukov.eclipse.aether.spi.log.LoggerFactory;
import com.github.igorsuhorukov.eclipse.aether.spi.log.NullLoggerFactory;
import com.github.igorsuhorukov.eclipse.aether.transfer.NoTransporterException;
import com.github.igorsuhorukov.eclipse.aether.transport.http.HttpTransporter;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="http")
public final class HttpTransporterFactory
implements TransporterFactory,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private float priority = 5.0f;

    public HttpTransporterFactory() {
    }

    @Inject
    HttpTransporterFactory(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
    }

    public HttpTransporterFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, HttpTransporter.class);
        return this;
    }

    public float getPriority() {
        return this.priority;
    }

    public HttpTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public Transporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        return new HttpTransporter(repository, session, this.logger);
    }
}

