/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.base;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Optional;
import javax.annotation.Nullable;

final class Absent<T>
extends Optional<T> {
    private static Absent<Object> INSTANCE = new Absent();

    static <T> Optional<T> withType() {
        return INSTANCE;
    }

    private Absent() {
    }

    @Override
    public final boolean isPresent() {
        return false;
    }

    @Override
    public final T get() {
        throw new IllegalStateException("Optional.get() cannot be called on an absent value");
    }

    @Override
    public final T or(T defaultValue) {
        return Ascii.checkNotNull(defaultValue, "use Optional.orNull() instead of Optional.or(null)");
    }

    public final boolean equals(@Nullable Object object) {
        return object == this;
    }

    public final int hashCode() {
        return 1502476572;
    }

    public final String toString() {
        return "Optional.absent()";
    }
}

