/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.base;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Predicate;
import java.util.Arrays;
import javax.annotation.CheckReturnValue;

public abstract class CharMatcher
implements Predicate<Character> {
    private static final String NINES;
    public static final CharMatcher NONE;
    private String description;
    static final int WHITESPACE_SHIFT;
    public static final CharMatcher WHITESPACE;

    /*
     * WARNING - void declaration
     */
    private static String showCharacter(char c) {
        void var2_2;
        String hex = "0123456789ABCDEF";
        char[] tmp = new char[]{'\\', 'u', '\u0000', '\u0000', '\u0000', '\u0000'};
        for (int i = 0; i < 4; ++i) {
            tmp[5 - i] = hex.charAt(c & 0xF);
            c = (char)(c >> 4);
        }
        return String.copyValueOf((char[])var2_2);
    }

    public static CharMatcher is(char match) {
        char c;
        String string = String.valueOf(String.valueOf(CharMatcher.showCharacter(match)));
        String description = new StringBuilder(18 + string.length()).append("CharMatcher.is('").append(string).append("')").toString();
        return new FastMatcher(string, c){
            private /* synthetic */ char val$match;
            {
                void var1_1;
                this.val$match = c;
                super((String)var1_1);
            }

            @Override
            public final boolean matches(char c) {
                return c == this.val$match;
            }

            @Override
            public final String replaceFrom(CharSequence sequence, char replacement) {
                return sequence.toString().replace(this.val$match, '/');
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final CharMatcher or(CharMatcher other) {
                void var1_1;
                if (other.matches(this.val$match)) {
                    return other;
                }
                return super.or((CharMatcher)var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static CharMatcher inRange(char startInclusive, char endInclusive) {
        void var1_1;
        char c;
        Ascii.checkArgument(endInclusive >= startInclusive);
        String string = String.valueOf(String.valueOf(CharMatcher.showCharacter(startInclusive)));
        String string2 = String.valueOf(String.valueOf(CharMatcher.showCharacter(endInclusive)));
        String description = new StringBuilder(27 + string.length() + string2.length()).append("CharMatcher.inRange('").append(string).append("', '").append(string2).append("')").toString();
        return CharMatcher.inRange(c, (char)var1_1, string);
    }

    /*
     * WARNING - void declaration
     */
    private static CharMatcher inRange(char startInclusive, char endInclusive, String description) {
        void var1_1;
        char c;
        void var2_2;
        return new FastMatcher((String)var2_2, c, (char)var1_1){
            private /* synthetic */ char val$startInclusive;
            private /* synthetic */ char val$endInclusive;
            {
                void var1_1;
                this.val$startInclusive = c;
                this.val$endInclusive = c2;
                super((String)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean matches(char c) {
                void var1_1;
                return this.val$startInclusive <= c && var1_1 <= this.val$endInclusive;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    CharMatcher(String description) {
        void var1_1;
        this.description = var1_1;
    }

    protected CharMatcher() {
        this.description = super.toString();
    }

    public abstract boolean matches(char var1);

    /*
     * WARNING - void declaration
     */
    public CharMatcher or(CharMatcher other) {
        void var1_1;
        return new Or(this, (CharMatcher)Ascii.checkNotNull(var1_1));
    }

    CharMatcher withToString(String description) {
        throw new UnsupportedOperationException();
    }

    public int indexIn(CharSequence sequence) {
        int length = sequence.length();
        for (int i = 0; i < length; ++i) {
            if (!this.matches(sequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public int indexIn(CharSequence sequence, int start) {
        void i;
        int length = sequence.length();
        Ascii.checkPositionIndex(start, length);
        while (i < length) {
            if (this.matches(sequence.charAt((int)i))) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @CheckReturnValue
    public String replaceFrom(CharSequence sequence, char replacement) {
        void var1_1;
        String string = sequence.toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] chars = cArray;
        cArray[pos] = 47;
        for (int i = pos + 1; i < chars.length; ++i) {
            if (!this.matches(chars[i])) continue;
            chars[i] = 47;
        }
        return new String((char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final boolean apply(Character character) {
        void var1_1;
        return this.matches(var1_1.charValue());
    }

    public String toString() {
        return this.description;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        new CharMatcher(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean matches(char c) {
                void var1_1;
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u0085': 
                    case '\u1680': 
                    case '\u2028': 
                    case '\u2029': 
                    case '\u205f': 
                    case '\u3000': {
                        return true;
                    }
                    case '\u2007': {
                        return false;
                    }
                }
                return c >= '\u2000' && var1_1 <= 8202;
            }

            @Override
            public final String toString() {
                return "CharMatcher.BREAKING_WHITESPACE";
            }
        };
        CharMatcher.inRange('\u0000', '\u007f', "CharMatcher.ASCII");
        StringBuilder builder = new StringBuilder(31);
        for (int i = 0; i < 31; ++i) {
            builder.append((char)("0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10".charAt(i) + 9));
        }
        NINES = var0.toString();
        new RangesMatcher("CharMatcher.DIGIT", "0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10".toCharArray(), NINES.toCharArray());
        new CharMatcher("CharMatcher.JAVA_DIGIT"){
            {
                void var1_1;
            }

            @Override
            public final boolean matches(char c) {
                return Character.isDigit(c);
            }
        };
        new CharMatcher("CharMatcher.JAVA_LETTER"){
            {
                void var1_1;
            }

            @Override
            public final boolean matches(char c) {
                return Character.isLetter(c);
            }
        };
        new CharMatcher("CharMatcher.JAVA_LETTER_OR_DIGIT"){
            {
                void var1_1;
            }

            @Override
            public final boolean matches(char c) {
                return Character.isLetterOrDigit(c);
            }
        };
        new CharMatcher("CharMatcher.JAVA_UPPER_CASE"){
            {
                void var1_1;
            }

            @Override
            public final boolean matches(char c) {
                return Character.isUpperCase(c);
            }
        };
        new CharMatcher("CharMatcher.JAVA_LOWER_CASE"){
            {
                void var1_1;
            }

            @Override
            public final boolean matches(char c) {
                return Character.isLowerCase(c);
            }
        };
        CharMatcher.inRange('\u0000', '\u001f').or(CharMatcher.inRange('\u007f', '\u009f')).withToString("CharMatcher.JAVA_ISO_CONTROL");
        new RangesMatcher("CharMatcher.INVISIBLE", "\u0000\u007f\u00ad\u0600\u061c\u06dd\u070f\u1680\u180e\u2000\u2028\u205f\u2066\u2067\u2068\u2069\u206a\u3000\ud800\ufeff\ufff9\ufffa".toCharArray(), " \u00a0\u00ad\u0604\u061c\u06dd\u070f\u1680\u180e\u200f\u202f\u2064\u2066\u2067\u2068\u2069\u206f\u3000\uf8ff\ufeff\ufff9\ufffb".toCharArray());
        new RangesMatcher("CharMatcher.SINGLE_WIDTH", "\u0000\u05be\u05d0\u05f3\u0600\u0750\u0e00\u1e00\u2100\ufb50\ufe70\uff61".toCharArray(), "\u04f9\u05be\u05ea\u05f4\u06ff\u077f\u0e7f\u20af\u213a\ufdff\ufeff\uffdc".toCharArray());
        new FastMatcher("CharMatcher.ANY"){
            {
                void var1_1;
            }

            @Override
            public final boolean matches(char c) {
                return true;
            }

            @Override
            public final int indexIn(CharSequence sequence) {
                if (sequence.length() == 0) {
                    return -1;
                }
                return 0;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final int indexIn(CharSequence sequence, int start) {
                void var2_3;
                void var1_2;
                int length = sequence.length();
                Ascii.checkPositionIndex(start, length);
                if (start == var1_2) {
                    return -1;
                }
                return (int)var2_3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final String replaceFrom(CharSequence sequence, char replacement) {
                void var1_1;
                char[] array = new char[sequence.length()];
                Arrays.fill(array, '/');
                return new String((char[])var1_1);
            }

            @Override
            public final CharMatcher or(CharMatcher other) {
                Ascii.checkNotNull(other);
                return this;
            }
        };
        NONE = new FastMatcher("CharMatcher.NONE"){
            {
                void var1_1;
            }

            @Override
            public final boolean matches(char c) {
                return false;
            }

            @Override
            public final int indexIn(CharSequence sequence) {
                Ascii.checkNotNull(sequence);
                return -1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final int indexIn(CharSequence sequence, int start) {
                void var1_2;
                void var2_3;
                int length = sequence.length();
                Ascii.checkPositionIndex((int)var2_3, (int)var1_2);
                return -1;
            }

            @Override
            public final String replaceFrom(CharSequence sequence, char replacement) {
                return sequence.toString();
            }

            @Override
            public final CharMatcher or(CharMatcher other) {
                return Ascii.checkNotNull(other);
            }
        };
        WHITESPACE_SHIFT = Integer.numberOfLeadingZeros(32 - 1);
        WHITESPACE = new FastMatcher("WHITESPACE"){
            {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean matches(char c) {
                void var1_1;
                return "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".charAt(c * 1682554634 >>> WHITESPACE_SHIFT) == var1_1;
            }
        };
    }

    static abstract class FastMatcher
    extends CharMatcher {
        /*
         * WARNING - void declaration
         */
        FastMatcher(String description) {
            super((String)var1_1);
            void var1_1;
        }
    }

    static final class Or
    extends CharMatcher {
        private CharMatcher first;
        private CharMatcher second;

        /*
         * WARNING - void declaration
         */
        private Or(CharMatcher a, CharMatcher b, String description) {
            super((String)var3_3);
            void var2_2;
            void var1_1;
            void var3_3;
            this.first = (CharMatcher)Ascii.checkNotNull(var1_1);
            this.second = (CharMatcher)Ascii.checkNotNull(var2_2);
        }

        Or(CharMatcher a, CharMatcher b) {
            String string;
            String string2;
            string2 = String.valueOf(String.valueOf(string2));
            string = String.valueOf(String.valueOf(string));
            this(a, b, new StringBuilder(18 + string2.length() + string.length()).append("CharMatcher.or(").append(string2).append(", ").append(string).append(")").toString());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return this.first.matches(c) || this.second.matches((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final CharMatcher withToString(String description) {
            void var1_1;
            return new Or(this.first, this.second, (String)var1_1);
        }
    }

    static final class RangesMatcher
    extends CharMatcher {
        private final char[] rangeStarts;
        private final char[] rangeEnds;

        RangesMatcher(String description, char[] rangeStarts, char[] rangeEnds) {
            super(description);
            this.rangeStarts = rangeStarts;
            this.rangeEnds = rangeEnds;
            Ascii.checkArgument(rangeStarts.length == rangeEnds.length);
            for (int i = 0; i < rangeStarts.length; ++i) {
                Ascii.checkArgument(rangeStarts[i] <= rangeEnds[i]);
                if (i + 1 >= rangeStarts.length) continue;
                Ascii.checkArgument(rangeEnds[i] < rangeStarts[i + 1]);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var2_2;
            void var1_1;
            int index = Arrays.binarySearch(this.rangeStarts, c);
            if (index >= 0) {
                return true;
            }
            return (index = ~index - 1) >= 0 && var1_1 <= this.rangeEnds[var2_2];
        }
    }
}

